/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.common;

import com.bmc.arsys.common.AppException;
import com.bmc.arsys.common.CommonErrors;
import com.bmc.arsys.common.Holder;
import com.bmc.arsys.common.PropertyDefinition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SysConfig {
    private String configFileName;
    protected String configFilePath = null;
    private Map<String, Object> propsMap;
    private Map<String, PropertyDefinition> propDefinitionsMap;
    private boolean is_xml_configfile = false;
    private boolean readAllProps = true;
    protected static String PROPERTY_DELIMITER = ":";
    private static final String XML_SUFFIX = ".xml";
    private static final String COMMENT = "#";
    private String installDir;
    private static final String CONF_DIR = "conf";
    private static final String AR_CONFIG_DIR_ENV_VAR = "ARCONFIGDIR";
    private static final String USER_HOME_DIR_PROPERTY = "user.home";
    private static final String DEF_PARENT_DIR = "U:";

    public SysConfig(String string, String string2, Map<String, PropertyDefinition> map, boolean bl) throws AppException {
        if (string != null && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        this.installDir = string;
        this.configFileName = string2;
        this.propDefinitionsMap = map;
        this.readAllProps = bl;
        if (string2 != null && string2.endsWith(XML_SUFFIX)) {
            this.is_xml_configfile = true;
        }
    }

    private void initProps() {
        this.propsMap = new HashMap<String, Object>();
    }

    private void clearProps() {
        if (this.propsMap != null) {
            this.propsMap.clear();
            this.propsMap = null;
        }
    }

    public int loadConfigFile() throws Exception {
        int n = this.is_xml_configfile ? this.loadXMLConfigFile() : this.loadARConfigFile();
        return n;
    }

    private int loadARConfigFile() throws Exception {
        String string = this.getFullConfigFilePath();
        if (string == null) {
            throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.CFG_NOT_FOUNT.toIntValue(), CommonErrors.CFG_NOT_FOUNT.toDefMsg(), new Object[]{this.configFileName});
        }
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            this.initProps();
            String string2 = bufferedReader.readLine();
            int n = 0;
            while (string2 != null) {
                string2 = string2.trim();
                ++n;
                if (string2.startsWith(COMMENT)) {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                Holder<Object> holder = new Holder<Object>(null);
                Holder<Object> holder2 = new Holder<Object>(null);
                if (this.parseConfigLine(string2, holder, holder2) || string2.contains(PROPERTY_DELIMITER)) {
                    String string3 = holder.get();
                    String string4 = holder2.get();
                    if (string3 != null && string4 != null) {
                        string3 = string3.trim();
                        string4 = string4.trim();
                    } else {
                        int n2 = string2.indexOf(PROPERTY_DELIMITER);
                        string3 = string2.substring(0, n2).trim();
                        string4 = string2.substring(n2 + 1, string2.length()).trim();
                    }
                    PropertyDefinition propertyDefinition = this.propDefinitionsMap.get(string3);
                    if (propertyDefinition != null) {
                        Object object = propertyDefinition.getConvertedValue(string4);
                        if (this.propsMap.containsKey(string3)) {
                            Object object2 = this.propsMap.get(string3);
                            if (object2 instanceof List) {
                                ((List)object2).add(object);
                            } else {
                                LinkedList<Object> linkedList = new LinkedList<Object>();
                                linkedList.add(object2);
                                linkedList.add(object);
                                this.propsMap.put(string3, linkedList);
                            }
                        } else {
                            this.propsMap.put(string3, object);
                        }
                    } else if (this.readAllProps) {
                        this.propsMap.put(string3, string4);
                    }
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return 0;
    }

    private int loadXMLConfigFile() throws AppException {
        throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.NOT_IMPLEMENTED.toIntValue(), CommonErrors.NOT_IMPLEMENTED.toDefMsg(), new Object[]{"loadXMLConfigFile"});
    }

    public int reloadConfigFile() throws Exception {
        this.clearProps();
        return this.loadConfigFile();
    }

    public int writeConfigFile() throws Exception {
        int n = this.is_xml_configfile ? this.writeXMLConfigFile() : this.writeARConfigFile();
        return n;
    }

    public int writeARConfigFile() throws AppException {
        throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.NOT_IMPLEMENTED.toIntValue(), CommonErrors.NOT_IMPLEMENTED.toDefMsg(), new Object[]{"writeARConfigFile"});
    }

    public int writeXMLConfigFile() throws AppException {
        throw new AppException(CommonErrors.MSG_SET.toDefMsg(), CommonErrors.NOT_IMPLEMENTED.toIntValue(), CommonErrors.NOT_IMPLEMENTED.toDefMsg(), new Object[]{"writeXMLConfigFile"});
    }

    public Object getProperty(String string) {
        Object object = null;
        if (this.propsMap != null && this.propsMap.containsKey(string)) {
            object = this.propsMap.get(string);
        } else if (this.propDefinitionsMap.containsKey(string)) {
            object = this.propDefinitionsMap.get(string).getDefaultValue();
        }
        return object;
    }

    public void setProperty(String string, Object object) {
        this.propsMap.put(string, object);
    }

    protected Map<String, Object> getPropsMap() {
        return this.propsMap;
    }

    protected void setPropsMap(Map<String, Object> map) {
        this.propsMap = map;
    }

    protected Map<String, PropertyDefinition> getPropDefinitionsMap() {
        return this.propDefinitionsMap;
    }

    protected void setPropDefinitionsMap(Map<String, PropertyDefinition> map) {
        this.propDefinitionsMap = map;
    }

    protected String getFullConfigFilePath() {
        String string = null;
        if (this.configFilePath == null) {
            String string2;
            File file;
            if (this.installDir != null && (file = new File(string2 = this.installDir + CONF_DIR + File.separator + this.configFileName)).exists()) {
                this.configFilePath = this.installDir + CONF_DIR;
                string = string2;
            }
            if (string == null) {
                String string3;
                string2 = System.getenv(AR_CONFIG_DIR_ENV_VAR);
                if (string2 == null || !new File(string2).exists()) {
                    string2 = System.getProperty(USER_HOME_DIR_PROPERTY);
                }
                if (string2 == null || !new File(string2).exists()) {
                    string2 = DEF_PARENT_DIR;
                }
                if ((file = new File(string3 = !string2.endsWith(File.separator) ? string2 + File.separator + this.configFileName : string2 + this.configFileName)).exists()) {
                    this.configFilePath = !string2.endsWith(File.separator) ? string2 : string2.substring(0, string2.length() - 1);
                    string = string3;
                }
            }
        } else {
            string = this.configFilePath + File.separator + this.configFileName;
        }
        return string;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    protected boolean parseConfigLine(String string, Holder<String> holder, Holder<String> holder2) {
        return false;
    }
}

