/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;

public abstract class XdrEncodingStream {
    private String characterEncoding = null;

    public void beginEncoding(InetAddress receiverAddress, int receiverPort) throws OncRpcException, IOException {
    }

    public void endEncoding() throws OncRpcException, IOException {
    }

    public void close() throws OncRpcException, IOException {
    }

    public abstract void xdrEncodeInt(int var1) throws OncRpcException, IOException;

    public abstract void xdrEncodeOpaque(byte[] var1, int var2, int var3) throws OncRpcException, IOException;

    public final void xdrEncodeDynamicOpaque(byte[] value) throws OncRpcException, IOException {
        this.xdrEncodeInt(value.length);
        this.xdrEncodeOpaque(value);
    }

    public final void xdrEncodeOpaque(byte[] value) throws OncRpcException, IOException {
        this.xdrEncodeOpaque(value, 0, value.length);
    }

    public final void xdrEncodeOpaque(byte[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        this.xdrEncodeOpaque(value, 0, value.length);
    }

    public final void xdrEncodeByteVector(byte[] value) throws OncRpcException, IOException {
        int length = value.length;
        this.xdrEncodeInt(length);
        if (length != 0) {
            for (int i2 = 0; i2 < length; ++i2) {
                this.xdrEncodeInt(value[i2]);
            }
        }
    }

    public final void xdrEncodeByteFixedVector(byte[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        if (length != 0) {
            for (int i2 = 0; i2 < length; ++i2) {
                this.xdrEncodeInt(value[i2]);
            }
        }
    }

    public final void xdrEncodeByte(byte value) throws OncRpcException, IOException {
        this.xdrEncodeInt(value);
    }

    public final void xdrEncodeShort(short value) throws OncRpcException, IOException {
        this.xdrEncodeInt(value);
    }

    public final void xdrEncodeLong(long value) throws OncRpcException, IOException {
        this.xdrEncodeInt((int)(value >>> 32));
        this.xdrEncodeInt((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    public final void xdrEncodeFloat(float value) throws OncRpcException, IOException {
        this.xdrEncodeInt(Float.floatToIntBits(value));
    }

    public final void xdrEncodeDouble(double value) throws OncRpcException, IOException {
        this.xdrEncodeLong(Double.doubleToLongBits(value));
    }

    public final void xdrEncodeBoolean(boolean value) throws OncRpcException, IOException {
        this.xdrEncodeInt(value ? 1 : 0);
    }

    public void xdrEncodeString(String value) throws OncRpcException, IOException {
        if (this.characterEncoding != null) {
            this.xdrEncodeDynamicOpaque(value.getBytes(this.characterEncoding));
        } else {
            this.xdrEncodeDynamicOpaque(value.getBytes());
        }
    }

    public final void xdrEncodeShortVector(short[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i2 = 0; i2 < size; ++i2) {
            this.xdrEncodeShort(value[i2]);
        }
    }

    public final void xdrEncodeShortFixedVector(short[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < length; ++i2) {
            this.xdrEncodeShort(value[i2]);
        }
    }

    public final void xdrEncodeIntVector(int[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i2 = 0; i2 < size; ++i2) {
            this.xdrEncodeInt(value[i2]);
        }
    }

    public final void xdrEncodeIntFixedVector(int[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < length; ++i2) {
            this.xdrEncodeInt(value[i2]);
        }
    }

    public final void xdrEncodeLongVector(long[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i2 = 0; i2 < size; ++i2) {
            this.xdrEncodeLong(value[i2]);
        }
    }

    public final void xdrEncodeLongFixedVector(long[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < length; ++i2) {
            this.xdrEncodeLong(value[i2]);
        }
    }

    public final void xdrEncodeFloatVector(float[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i2 = 0; i2 < size; ++i2) {
            this.xdrEncodeFloat(value[i2]);
        }
    }

    public final void xdrEncodeFloatFixedVector(float[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < length; ++i2) {
            this.xdrEncodeFloat(value[i2]);
        }
    }

    public final void xdrEncodeDoubleVector(double[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i2 = 0; i2 < size; ++i2) {
            this.xdrEncodeDouble(value[i2]);
        }
    }

    public final void xdrEncodeDoubleFixedVector(double[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < length; ++i2) {
            this.xdrEncodeDouble(value[i2]);
        }
    }

    public final void xdrEncodeBooleanVector(boolean[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i2 = 0; i2 < size; ++i2) {
            this.xdrEncodeBoolean(value[i2]);
        }
    }

    public final void xdrEncodeBooleanFixedVector(boolean[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < length; ++i2) {
            this.xdrEncodeBoolean(value[i2]);
        }
    }

    public final void xdrEncodeStringVector(String[] value) throws OncRpcException, IOException {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i2 = 0; i2 < size; ++i2) {
            this.xdrEncodeString(value[i2]);
        }
    }

    public final void xdrEncodeStringFixedVector(String[] value, int length) throws OncRpcException, IOException {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < length; ++i2) {
            this.xdrEncodeString(value[i2]);
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

