/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.multipart.support;

import com.bmc.thirdparty.org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DefaultMultipartHttpServletRequest
extends AbstractMultipartHttpServletRequest {
    private final Map multipartParameters;

    public DefaultMultipartHttpServletRequest(HttpServletRequest request, Map multipartFiles, Map multipartParameters) {
        super(request);
        this.setMultipartFiles(multipartFiles);
        this.multipartParameters = multipartParameters;
    }

    public Enumeration getParameterNames() {
        HashSet<Object> paramNames = new HashSet<Object>();
        Enumeration paramEnum = super.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            paramNames.add(paramEnum.nextElement());
        }
        paramNames.addAll(this.multipartParameters.keySet());
        return Collections.enumeration(paramNames);
    }

    public String getParameter(String name) {
        String[] values = (String[])this.multipartParameters.get(name);
        if (values != null) {
            return values.length > 0 ? values[0] : null;
        }
        return super.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        String[] values = (String[])this.multipartParameters.get(name);
        if (values != null) {
            return values;
        }
        return super.getParameterValues(name);
    }

    public Map getParameterMap() {
        HashMap paramMap = new HashMap();
        paramMap.putAll(super.getParameterMap());
        paramMap.putAll(this.multipartParameters);
        return paramMap;
    }
}

