/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.datasource.lookup;

import com.bmc.thirdparty.org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import com.bmc.thirdparty.org.springframework.jdbc.datasource.lookup.DataSourceLookupFailureException;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class MapDataSourceLookup
implements DataSourceLookup {
    private final Map dataSources = new HashMap(4);

    public MapDataSourceLookup() {
    }

    public MapDataSourceLookup(Map dataSources) {
        this.setDataSources(dataSources);
    }

    public MapDataSourceLookup(String dataSourceName, DataSource dataSource) {
        this.addDataSource(dataSourceName, dataSource);
    }

    public void setDataSources(Map dataSources) {
        if (dataSources != null) {
            this.dataSources.putAll(dataSources);
        }
    }

    public Map getDataSources() {
        return Collections.unmodifiableMap(this.dataSources);
    }

    public void addDataSource(String dataSourceName, DataSource dataSource) {
        Assert.notNull(dataSourceName, "DataSource name must not be null");
        Assert.notNull(dataSource, "DataSource must not be null");
        this.dataSources.put(dataSourceName, dataSource);
    }

    public DataSource getDataSource(String dataSourceName) throws DataSourceLookupFailureException {
        Assert.notNull(dataSourceName, "DataSource name must not be null");
        Object value = this.dataSources.get(dataSourceName);
        if (value == null) {
            throw new DataSourceLookupFailureException("No DataSource with name '" + dataSourceName + "' registered");
        }
        if (!(value instanceof DataSource)) {
            throw new DataSourceLookupFailureException("The object [" + value + "] with name '" + dataSourceName + "' in the DataSource map is not a [javax.sql.DataSource]");
        }
        return (DataSource)value;
    }
}

