/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.support;

import com.bmc.thirdparty.org.springframework.aop.support.StaticMethodMatcherPointcut;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;

public abstract class AbstractRegexpMethodPointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    private String[] patterns = new String[0];
    private String[] excludedPatterns = new String[0];

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public void setPatterns(String[] patterns) {
        Assert.notEmpty(patterns, "'patterns' cannot be null or empty.");
        this.patterns = patterns;
        this.initPatternRepresentation(patterns);
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setExcludedPattern(String excludedPattern) {
        this.setExcludedPatterns(new String[]{excludedPattern});
    }

    public void setExcludedPatterns(String[] excludedPatterns) {
        Assert.notEmpty(excludedPatterns, "excludedPatterns must not be empty");
        this.excludedPatterns = excludedPatterns;
        this.initExcludedPatternRepresentation(excludedPatterns);
    }

    public String[] getExcludedPatterns() {
        return this.excludedPatterns;
    }

    public final boolean matches(Method method, Class targetClass) {
        String patt = method.getDeclaringClass().getName() + "." + method.getName();
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            boolean matched = this.matches(patt, i2);
            if (!matched) continue;
            for (int j2 = 0; j2 < this.excludedPatterns.length; ++j2) {
                boolean excluded = this.matchesExclusion(patt, j2);
                if (!excluded) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract void initPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract void initExcludedPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract boolean matches(String var1, int var2);

    protected abstract boolean matchesExclusion(String var1, int var2);

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractRegexpMethodPointcut)) {
            return false;
        }
        AbstractRegexpMethodPointcut otherPointcut = (AbstractRegexpMethodPointcut)other;
        return Arrays.equals(this.patterns, otherPointcut.patterns) && Arrays.equals(this.excludedPatterns, otherPointcut.excludedPatterns);
    }

    public int hashCode() {
        int i2;
        int result = 27;
        for (i2 = 0; i2 < this.patterns.length; ++i2) {
            String pattern = this.patterns[i2];
            result = 13 * result + pattern.hashCode();
        }
        for (i2 = 0; i2 < this.excludedPatterns.length; ++i2) {
            String excludedPattern = this.excludedPatterns[i2];
            result = 13 * result + excludedPattern.hashCode();
        }
        return result;
    }

    public String toString() {
        return this.getClass().getName() + ": patterns " + ObjectUtils.nullSafeToString(this.patterns) + ", excluded patterns " + ObjectUtils.nullSafeToString(this.excludedPatterns);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.initPatternRepresentation(this.patterns);
        this.initExcludedPatternRepresentation(this.excludedPatterns);
    }
}

