/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.configuration;

import com.bmc.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.DataSource;

public class DatabaseConfiguration
extends AbstractConfiguration {
    private static Log log = LogFactory.getLog(class$org$apache$commons$configuration$DatabaseConfiguration == null ? (class$org$apache$commons$configuration$DatabaseConfiguration = DatabaseConfiguration.class$("com.bmc.thirdparty.org.apache.commons.configuration.DatabaseConfiguration")) : class$org$apache$commons$configuration$DatabaseConfiguration);
    private DataSource datasource;
    private String table;
    private String nameColumn;
    private String keyColumn;
    private String valueColumn;
    private String name;
    static /* synthetic */ Class class$org$apache$commons$configuration$DatabaseConfiguration;

    public DatabaseConfiguration(DataSource datasource, String table, String nameColumn, String keyColumn, String valueColumn, String name) {
        this.datasource = datasource;
        this.table = table;
        this.nameColumn = nameColumn;
        this.keyColumn = keyColumn;
        this.valueColumn = valueColumn;
        this.name = name;
    }

    public DatabaseConfiguration(DataSource datasource, String table, String keyColumn, String valueColumn) {
        this(datasource, table, null, keyColumn, valueColumn, null);
    }

    public Object getProperty(String key) {
        ArrayList<Object> result = null;
        StringBuffer query = new StringBuffer("SELECT * FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            block8: {
                try {
                    ResultSet rs;
                    conn = this.datasource.getConnection();
                    pstmt = conn.prepareStatement(query.toString());
                    pstmt.setString(1, key);
                    if (this.nameColumn != null) {
                        pstmt.setString(2, this.name);
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        result = rs.getObject(this.valueColumn);
                    }
                    if (!rs.next()) break block8;
                    ArrayList<Object> results = new ArrayList<Object>();
                    results.add(result);
                    results.add(rs.getObject(this.valueColumn));
                    while (rs.next()) {
                        results.add(rs.getObject(this.valueColumn));
                    }
                    result = results;
                }
                catch (SQLException e2) {
                    log.error(e2.getMessage(), e2);
                    Object var9_10 = null;
                    this.closeQuietly(conn, pstmt);
                }
            }
            Object var9_9 = null;
            this.closeQuietly(conn, pstmt);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.closeQuietly(conn, pstmt);
            throw throwable;
        }
        return result;
    }

    protected void addPropertyDirect(String key, Object obj) {
        StringBuffer query = new StringBuffer("INSERT INTO " + this.table);
        if (this.nameColumn != null) {
            query.append(" (" + this.nameColumn + ", " + this.keyColumn + ", " + this.valueColumn + ") VALUES (?, ?, ?)");
        } else {
            query.append(" (" + this.keyColumn + ", " + this.valueColumn + ") VALUES (?, ?)");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            try {
                conn = this.datasource.getConnection();
                pstmt = conn.prepareStatement(query.toString());
                int index = 1;
                if (this.nameColumn != null) {
                    pstmt.setString(index++, this.name);
                }
                pstmt.setString(index++, key);
                pstmt.setString(index++, String.valueOf(obj));
                pstmt.executeUpdate();
            }
            catch (SQLException e2) {
                log.error(e2.getMessage(), e2);
                Object var8_9 = null;
                this.closeQuietly(conn, pstmt);
            }
            Object var8_8 = null;
            this.closeQuietly(conn, pstmt);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeQuietly(conn, pstmt);
            throw throwable;
        }
    }

    public boolean isEmpty() {
        boolean empty = true;
        StringBuffer query = new StringBuffer("SELECT count(*) FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            block6: {
                try {
                    ResultSet rs;
                    conn = this.datasource.getConnection();
                    pstmt = conn.prepareStatement(query.toString());
                    if (this.nameColumn != null) {
                        pstmt.setString(1, this.name);
                    }
                    if (!(rs = pstmt.executeQuery()).next()) break block6;
                    empty = rs.getInt(1) == 0;
                }
                catch (SQLException e2) {
                    log.error(e2.getMessage(), e2);
                    Object var7_8 = null;
                    this.closeQuietly(conn, pstmt);
                }
            }
            Object var7_7 = null;
            this.closeQuietly(conn, pstmt);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeQuietly(conn, pstmt);
            throw throwable;
        }
        return empty;
    }

    public boolean containsKey(String key) {
        boolean found = false;
        StringBuffer query = new StringBuffer("SELECT * FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            try {
                conn = this.datasource.getConnection();
                pstmt = conn.prepareStatement(query.toString());
                pstmt.setString(1, key);
                if (this.nameColumn != null) {
                    pstmt.setString(2, this.name);
                }
                ResultSet rs = pstmt.executeQuery();
                found = rs.next();
            }
            catch (SQLException e2) {
                log.error(e2.getMessage(), e2);
                Object var8_9 = null;
                this.closeQuietly(conn, pstmt);
            }
            Object var8_8 = null;
            this.closeQuietly(conn, pstmt);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeQuietly(conn, pstmt);
            throw throwable;
        }
        return found;
    }

    public void clearProperty(String key) {
        StringBuffer query = new StringBuffer("DELETE FROM " + this.table + " WHERE " + this.keyColumn + "=?");
        if (this.nameColumn != null) {
            query.append(" AND " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            try {
                conn = this.datasource.getConnection();
                pstmt = conn.prepareStatement(query.toString());
                pstmt.setString(1, key);
                if (this.nameColumn != null) {
                    pstmt.setString(2, this.name);
                }
                pstmt.executeUpdate();
            }
            catch (SQLException e2) {
                log.error(e2.getMessage(), e2);
                Object var7_6 = null;
                this.closeQuietly(conn, pstmt);
            }
            Object var7_5 = null;
            this.closeQuietly(conn, pstmt);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.closeQuietly(conn, pstmt);
            throw throwable;
        }
    }

    public void clear() {
        StringBuffer query = new StringBuffer("DELETE FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            try {
                conn = this.datasource.getConnection();
                pstmt = conn.prepareStatement(query.toString());
                if (this.nameColumn != null) {
                    pstmt.setString(1, this.name);
                }
                pstmt.executeUpdate();
            }
            catch (SQLException e2) {
                log.error(e2.getMessage(), e2);
                Object var6_5 = null;
                this.closeQuietly(conn, pstmt);
            }
            Object var6_4 = null;
            this.closeQuietly(conn, pstmt);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.closeQuietly(conn, pstmt);
            throw throwable;
        }
    }

    public Iterator getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        StringBuffer query = new StringBuffer("SELECT DISTINCT " + this.keyColumn + " FROM " + this.table);
        if (this.nameColumn != null) {
            query.append(" WHERE " + this.nameColumn + "=?");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            try {
                conn = this.datasource.getConnection();
                pstmt = conn.prepareStatement(query.toString());
                if (this.nameColumn != null) {
                    pstmt.setString(1, this.name);
                }
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    keys.add(rs.getString(1));
                }
            }
            catch (SQLException e2) {
                log.error(e2.getMessage(), e2);
                Object var7_8 = null;
                this.closeQuietly(conn, pstmt);
            }
            Object var7_7 = null;
            this.closeQuietly(conn, pstmt);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeQuietly(conn, pstmt);
            throw throwable;
        }
        return keys.iterator();
    }

    private void closeQuietly(Connection conn, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            log.error(e2.getMessage(), e2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

