/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcClientAuth;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrAble;

public abstract class OncRpcClient {
    protected InetAddress host;
    protected int timeout = 30000;
    protected int program;
    protected int version;
    protected int port;
    protected int xid;
    protected OncRpcClientAuth auth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OncRpcClient(InetAddress host, int program, int version, int port, int protocol) throws OncRpcException, IOException {
        this.host = host;
        this.program = program;
        this.version = version;
        long seed = System.currentTimeMillis();
        this.xid = (int)seed ^ (int)(seed >>> 32);
        if (port == 0 && protocol != -42) {
            OncRpcPortmapClient portmap = new OncRpcPortmapClient(host, protocol);
            try {
                port = portmap.getPort(program, version, protocol);
            }
            finally {
                portmap.close();
            }
        }
        this.port = port;
    }

    public static OncRpcClient newOncRpcClient(InetAddress host, int program, int version, int protocol) throws OncRpcException, IOException {
        return OncRpcClient.newOncRpcClient(host, program, version, 0, protocol);
    }

    public static OncRpcClient newOncRpcClient(InetAddress host, int program, int version, int port, int protocol) throws OncRpcException, IOException {
        switch (protocol) {
            case 17: {
                return new OncRpcUdpClient(host, program, version, port);
            }
            case 6: {
                return new OncRpcTcpClient(host, program, version, port);
            }
        }
        throw new OncRpcException(17);
    }

    public void close() throws OncRpcException {
    }

    public synchronized void call(int procedureNumber, XdrAble params, XdrAble result) throws OncRpcException {
        this.call(procedureNumber, this.version, params, result);
    }

    public abstract void call(int var1, int var2, XdrAble var3, XdrAble var4) throws OncRpcException;

    public void setTimeout(int milliseconds) {
        if (milliseconds < 0) {
            throw new IllegalArgumentException("timeouts can not be negative.");
        }
        this.timeout = milliseconds;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getProgram() {
        return this.program;
    }

    public int getVersion() {
        return this.version;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setAuth(OncRpcClientAuth auth) {
        this.auth = auth;
    }

    public OncRpcClientAuth getAuth() {
        return this.auth;
    }

    public abstract void setCharacterEncoding(String var1);

    public abstract String getCharacterEncoding();

    protected void nextXid() {
        ++this.xid;
        this.xid &= Integer.MAX_VALUE;
    }
}

