/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.config;

import com.bmc.thirdparty.org.springframework.aop.config.AdviceEntry;
import com.bmc.thirdparty.org.springframework.aop.config.AdvisorComponentDefinition;
import com.bmc.thirdparty.org.springframework.aop.config.AdvisorEntry;
import com.bmc.thirdparty.org.springframework.aop.config.AopNamespaceUtils;
import com.bmc.thirdparty.org.springframework.aop.config.AspectComponentDefinition;
import com.bmc.thirdparty.org.springframework.aop.config.AspectEntry;
import com.bmc.thirdparty.org.springframework.aop.config.PointcutComponentDefinition;
import com.bmc.thirdparty.org.springframework.aop.config.PointcutEntry;
import com.bmc.thirdparty.org.springframework.beans.MutablePropertyValues;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanReference;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConstructorArgumentValues;
import com.bmc.thirdparty.org.springframework.beans.factory.config.RuntimeBeanReference;
import com.bmc.thirdparty.org.springframework.beans.factory.parsing.ParseState;
import com.bmc.thirdparty.org.springframework.beans.factory.support.AbstractBeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionBuilder;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bmc.thirdparty.org.springframework.beans.factory.support.RootBeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.BeanDefinitionParser;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.ParserContext;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.util.xml.DomUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ConfigBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ASPECT = "aspect";
    private static final String EXPRESSION = "expression";
    private static final String ID = "id";
    private static final String POINTCUT = "pointcut";
    private static final String ADVICE = "advice";
    private static final String ADVISOR = "advisor";
    private static final String ADVICE_REF = "advice-ref";
    private static final String POINTCUT_REF = "pointcut-ref";
    private static final String REF = "ref";
    private static final String KIND = "kind";
    private static final String BEFORE = "before";
    private static final String DECLARE_PARENTS = "declare-parents";
    private static final String TYPE_PATTERN = "types-matching";
    private static final String DEFAULT_IMPL = "default-impl";
    private static final String IMPLEMENT_INTERFACE = "implement-interface";
    private static final String AFTER = "after";
    private static final String AFTER_RETURNING = "afterReturning";
    private static final String AFTER_THROWING = "afterThrowing";
    private static final String AFTER_RETURNING_ELEMENT = "after-returning";
    private static final String AFTER_THROWING_ELEMENT = "after-throwing";
    private static final String AROUND = "around";
    private static final String PROXY_TARGET_CLASS = "proxy-target-class";
    private static final String TRUE = "true";
    private static final String RETURNING = "returning";
    private static final String RETURNING_PROPERTY = "returningName";
    private static final String THROWING = "throwing";
    private static final String THROWING_PROPERTY = "throwingName";
    private static final String ARG_NAMES = "arg-names";
    private static final String ARG_NAMES_PROPERTY = "argumentNames";
    private static final String ASPECT_NAME_PROPERTY = "aspectName";
    private static final String ASPECT_BEAN_PROPERTY = "aspectBean";
    private static final String DECLARATION_ORDER_PROPERTY = "declarationOrder";
    private static final String ORDER_PROPERTY = "order";
    private static final int METHOD_INDEX = 0;
    private static final int POINTCUT_INDEX = 1;
    private static final int ASPECT_INSTANCE_FACTORY_INDEX = 2;
    private static final int PARAMETER_NAME_DISCOVERER = 3;
    private ParseState parseState = new ParseState();
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJPointcutAdvisor;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$DeclareParentsAdvisor;
    static /* synthetic */ Class class$org$springframework$aop$config$MethodLocatingFactoryBean;
    static /* synthetic */ Class class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory;
    static /* synthetic */ Class class$org$springframework$core$PrioritizedParameterNameDiscoverer;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJAroundAdvice;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$AspectJExpressionPointcut;

    ConfigBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.configureAutoProxyCreator(parserContext, element);
        NodeList childNodes = element.getChildNodes();
        for (int i2 = 0; i2 < childNodes.getLength(); ++i2) {
            Node node = childNodes.item(i2);
            if (node.getNodeType() != 1) continue;
            String localName = node.getLocalName();
            if (POINTCUT.equals(localName)) {
                this.parsePointcut((Element)node, parserContext);
                continue;
            }
            if (ADVISOR.equals(localName)) {
                this.parseAdvisor((Element)node, parserContext);
                continue;
            }
            if (!ASPECT.equals(localName)) continue;
            this.parseAspect((Element)node, parserContext);
        }
        return null;
    }

    private void configureAutoProxyCreator(ParserContext parserContext, Element element) {
        AopNamespaceUtils.registerAspectJAutoProxyCreatorIfNecessary(parserContext, element);
        boolean proxyTargetClass = TRUE.equals(element.getAttribute(PROXY_TARGET_CLASS));
        if (proxyTargetClass) {
            AopNamespaceUtils.forceAutoProxyCreatorToUseClassProxying(parserContext.getRegistry());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAdvisor(Element advisorElement, ParserContext parserContext) {
        AbstractBeanDefinition advisorDef = this.createAdvisorBeanDefinition(advisorElement, parserContext);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        String advisorBeanName = advisorElement.getAttribute(ID);
        if (!StringUtils.hasText(advisorBeanName)) {
            advisorBeanName = BeanDefinitionReaderUtils.generateBeanName(advisorDef, registry);
        }
        try {
            this.parseState.push(new AdvisorEntry(advisorBeanName));
            String pointcutBeanName = this.parsePointcutProperty(advisorElement, advisorDef.getPropertyValues(), parserContext);
            registry.registerBeanDefinition(advisorBeanName, advisorDef);
            boolean pointcutRef = advisorElement.hasAttribute(POINTCUT_REF);
            if (pointcutBeanName != null) {
                this.fireAdvisorEvent(advisorBeanName, pointcutBeanName, advisorDef, parserContext, pointcutRef);
            }
        }
        finally {
            this.parseState.pop();
        }
    }

    private void fireAdvisorEvent(String advisorBeanName, String pointcutBeanName, AbstractBeanDefinition advisorDefinition, ParserContext parserContext, boolean pointcutRef) {
        AdvisorComponentDefinition componentDefinition;
        if (pointcutRef) {
            componentDefinition = new AdvisorComponentDefinition(advisorBeanName, advisorDefinition);
        } else {
            BeanDefinition pointcutDefinition = parserContext.getRegistry().getBeanDefinition(pointcutBeanName);
            componentDefinition = new AdvisorComponentDefinition(advisorBeanName, advisorDefinition, pointcutDefinition);
        }
        parserContext.getReaderContext().fireComponentRegistered(componentDefinition);
    }

    private AbstractBeanDefinition createAdvisorBeanDefinition(Element advisorElement, ParserContext parserContext) {
        RootBeanDefinition advisorDefinition = new RootBeanDefinition(class$org$springframework$aop$aspectj$AspectJPointcutAdvisor == null ? (class$org$springframework$aop$aspectj$AspectJPointcutAdvisor = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJPointcutAdvisor")) : class$org$springframework$aop$aspectj$AspectJPointcutAdvisor);
        advisorDefinition.setSource(parserContext.extractSource(advisorElement));
        MutablePropertyValues mpvs = advisorDefinition.getPropertyValues();
        if (advisorElement.hasAttribute(ORDER_PROPERTY)) {
            mpvs.addPropertyValue(ORDER_PROPERTY, advisorElement.getAttribute(ORDER_PROPERTY));
        }
        advisorDefinition.setPropertyValues(mpvs);
        mpvs.addPropertyValue(ADVICE, new RuntimeBeanReference(advisorElement.getAttribute(ADVICE_REF)));
        return advisorDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAspect(Element aspectElement, ParserContext parserContext) {
        String aspectName = aspectElement.getAttribute(REF);
        String aspectId = aspectElement.getAttribute(ID);
        try {
            this.parseState.push(new AspectEntry(aspectId, aspectName));
            ArrayList<AbstractBeanDefinition> beanDefinitions = new ArrayList<AbstractBeanDefinition>();
            ArrayList<Object> beanReferences = new ArrayList<Object>();
            beanReferences.add(new RuntimeBeanReference(aspectName));
            List pointcuts = DomUtils.getChildElementsByTagName(aspectElement, POINTCUT);
            for (int i2 = 0; i2 < pointcuts.size(); ++i2) {
                Element pointcutElement = (Element)pointcuts.get(i2);
                beanDefinitions.add(this.parsePointcut(pointcutElement, parserContext));
            }
            List declareParents = DomUtils.getChildElementsByTagName(aspectElement, DECLARE_PARENTS);
            for (int i3 = 0; i3 < declareParents.size(); ++i3) {
                Element declareParentsElement = (Element)declareParents.get(i3);
                beanDefinitions.add(this.parseDeclareParents(declareParentsElement, parserContext));
            }
            NodeList nodeList = aspectElement.getChildNodes();
            for (int i4 = 0; i4 < nodeList.getLength(); ++i4) {
                Node node = nodeList.item(i4);
                if (!this.isAdviceNode(node)) continue;
                AbstractBeanDefinition adviceDefinition = this.parseAdvice(aspectName, i4, (Element)node, parserContext);
                Object pointcut = adviceDefinition.getPropertyValues().getPropertyValue(POINTCUT).getValue();
                if (pointcut instanceof RuntimeBeanReference) {
                    beanReferences.add(pointcut);
                }
                beanDefinitions.add(adviceDefinition);
            }
            this.fireAspectEvent(aspectElement, aspectId, beanDefinitions, beanReferences, parserContext);
        }
        finally {
            this.parseState.pop();
        }
    }

    private void fireAspectEvent(Element aspectElement, String aspectId, List beanDefs, List beanRefs, ParserContext parserContext) {
        BeanDefinition[] beanDefArray = beanDefs.toArray(new BeanDefinition[beanDefs.size()]);
        BeanReference[] beanRefArray = beanRefs.toArray(new BeanReference[beanRefs.size()]);
        Object source = parserContext.extractSource(aspectElement);
        parserContext.getReaderContext().fireComponentRegistered(new AspectComponentDefinition(aspectId, beanDefArray, beanRefArray, source));
    }

    private boolean isAdviceNode(Node aNode) {
        if (!(aNode instanceof Element)) {
            return false;
        }
        String name = aNode.getLocalName();
        return BEFORE.equals(name) || AFTER.equals(name) || AFTER_RETURNING_ELEMENT.equals(name) || AFTER_THROWING_ELEMENT.equals(name) || AROUND.equals(name);
    }

    private AbstractBeanDefinition parseDeclareParents(Element declareParentsElement, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(class$org$springframework$aop$aspectj$DeclareParentsAdvisor == null ? (class$org$springframework$aop$aspectj$DeclareParentsAdvisor = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.aop.aspectj.DeclareParentsAdvisor")) : class$org$springframework$aop$aspectj$DeclareParentsAdvisor);
        builder.addConstructorArg(declareParentsElement.getAttribute(IMPLEMENT_INTERFACE));
        builder.addConstructorArg(declareParentsElement.getAttribute(TYPE_PATTERN));
        builder.addConstructorArg(declareParentsElement.getAttribute(DEFAULT_IMPL));
        builder.setSource(parserContext.extractSource(declareParentsElement));
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        String name = BeanDefinitionReaderUtils.generateBeanName(definition, parserContext.getRegistry());
        parserContext.getRegistry().registerBeanDefinition(name, definition);
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBeanDefinition parseAdvice(String aspectName, int order, Element adviceElement, ParserContext parserContext) {
        RootBeanDefinition advisorDefinition = null;
        try {
            this.parseState.push(new AdviceEntry(adviceElement.getLocalName()));
            MutablePropertyValues advisorProperties = new MutablePropertyValues();
            RootBeanDefinition methodDefinition = new RootBeanDefinition(class$org$springframework$aop$config$MethodLocatingFactoryBean == null ? (class$org$springframework$aop$config$MethodLocatingFactoryBean = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.aop.config.MethodLocatingFactoryBean")) : class$org$springframework$aop$config$MethodLocatingFactoryBean);
            methodDefinition.getPropertyValues().addPropertyValue("targetBeanName", aspectName);
            methodDefinition.getPropertyValues().addPropertyValue("methodName", adviceElement.getAttribute("method"));
            methodDefinition.setSynthetic(true);
            RootBeanDefinition instanceFactoryDefinition = new RootBeanDefinition(class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory == null ? (class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.aop.config.BeanFactoryAspectInstanceFactory")) : class$org$springframework$aop$config$BeanFactoryAspectInstanceFactory);
            instanceFactoryDefinition.getPropertyValues().addPropertyValue("aspectBeanName", aspectName);
            instanceFactoryDefinition.setSynthetic(true);
            AbstractBeanDefinition adviceDefinition = this.createAdviceDefinition(adviceElement, advisorProperties, parserContext, aspectName, order, methodDefinition, instanceFactoryDefinition);
            advisorDefinition = new RootBeanDefinition(class$org$springframework$aop$aspectj$AspectJPointcutAdvisor == null ? (class$org$springframework$aop$aspectj$AspectJPointcutAdvisor = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJPointcutAdvisor")) : class$org$springframework$aop$aspectj$AspectJPointcutAdvisor);
            advisorDefinition.setSource(parserContext.extractSource(adviceElement));
            advisorDefinition.setPropertyValues(advisorProperties);
            advisorDefinition.getPropertyValues().addPropertyValue(ADVICE, adviceDefinition);
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            BeanDefinitionReaderUtils.registerWithGeneratedName(advisorDefinition, registry);
        }
        finally {
            this.parseState.pop();
        }
        return advisorDefinition;
    }

    private AbstractBeanDefinition createAdviceDefinition(Element adviceElement, MutablePropertyValues advisorProperties, ParserContext parserContext, String aspectName, int order, RootBeanDefinition methodDefinition, RootBeanDefinition instanceFactoryDefinition) {
        String pointcutBeanName = this.parsePointcutProperty(adviceElement, advisorProperties, parserContext);
        RootBeanDefinition adviceDefinition = new RootBeanDefinition(this.getAdviceClass(adviceElement));
        adviceDefinition.setSource(parserContext.extractSource(adviceElement));
        boolean isAroundAdvice = AROUND.equals(adviceElement.getLocalName());
        adviceDefinition.getPropertyValues().addPropertyValue(ASPECT_NAME_PROPERTY, aspectName);
        adviceDefinition.getPropertyValues().addPropertyValue(ASPECT_BEAN_PROPERTY, new RuntimeBeanReference(aspectName));
        adviceDefinition.getPropertyValues().addPropertyValue(DECLARATION_ORDER_PROPERTY, new Integer(order));
        if (adviceElement.hasAttribute(RETURNING)) {
            adviceDefinition.getPropertyValues().addPropertyValue(RETURNING_PROPERTY, adviceElement.getAttribute(RETURNING));
        }
        if (adviceElement.hasAttribute(THROWING)) {
            adviceDefinition.getPropertyValues().addPropertyValue(THROWING_PROPERTY, adviceElement.getAttribute(THROWING));
        }
        if (adviceElement.hasAttribute(ARG_NAMES)) {
            adviceDefinition.getPropertyValues().addPropertyValue(ARG_NAMES_PROPERTY, adviceElement.getAttribute(ARG_NAMES));
        }
        ConstructorArgumentValues cav = new ConstructorArgumentValues();
        cav.addIndexedArgumentValue(0, methodDefinition);
        cav.addIndexedArgumentValue(1, new RuntimeBeanReference(pointcutBeanName));
        cav.addIndexedArgumentValue(2, instanceFactoryDefinition);
        if (isAroundAdvice) {
            this.extendAdviceConstructorArgs(cav);
        }
        adviceDefinition.setConstructorArgumentValues(cav);
        return adviceDefinition;
    }

    private void extendAdviceConstructorArgs(ConstructorArgumentValues cav) {
        RootBeanDefinition discovererDefinition = new RootBeanDefinition(class$org$springframework$core$PrioritizedParameterNameDiscoverer == null ? (class$org$springframework$core$PrioritizedParameterNameDiscoverer = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.core.PrioritizedParameterNameDiscoverer")) : class$org$springframework$core$PrioritizedParameterNameDiscoverer);
        cav.addIndexedArgumentValue(3, discovererDefinition);
    }

    private Class getAdviceClass(Element adviceElement) {
        String elementName = adviceElement.getLocalName();
        if (BEFORE.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice == null ? (class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJMethodBeforeAdvice")) : class$org$springframework$aop$aspectj$AspectJMethodBeforeAdvice;
        }
        if (AFTER.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterAdvice = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJAfterAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterAdvice;
        }
        if (AFTER_RETURNING_ELEMENT.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJAfterReturningAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterReturningAdvice;
        }
        if (AFTER_THROWING_ELEMENT.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJAfterThrowingAdvice")) : class$org$springframework$aop$aspectj$AspectJAfterThrowingAdvice;
        }
        if (AROUND.equals(elementName)) {
            return class$org$springframework$aop$aspectj$AspectJAroundAdvice == null ? (class$org$springframework$aop$aspectj$AspectJAroundAdvice = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJAroundAdvice")) : class$org$springframework$aop$aspectj$AspectJAroundAdvice;
        }
        throw new IllegalArgumentException("Unknown advice kind [" + elementName + "].");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBeanDefinition parsePointcut(Element pointcutElement, ParserContext parserContext) {
        String id = pointcutElement.getAttribute(ID);
        String expression = pointcutElement.getAttribute(EXPRESSION);
        AbstractBeanDefinition pointcutDefinition = null;
        try {
            this.parseState.push(new PointcutEntry(id));
            pointcutDefinition = this.createPointcutDefinition(expression);
            pointcutDefinition.setSource(parserContext.extractSource(pointcutElement));
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            if (!StringUtils.hasText(id)) {
                id = BeanDefinitionReaderUtils.generateBeanName(pointcutDefinition, registry);
            }
            registry.registerBeanDefinition(id, pointcutDefinition);
            PointcutComponentDefinition componentDef = new PointcutComponentDefinition(id, pointcutDefinition, expression);
            parserContext.getReaderContext().fireComponentRegistered(componentDef);
        }
        finally {
            this.parseState.pop();
        }
        return pointcutDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parsePointcutProperty(Element element, MutablePropertyValues mpvs, ParserContext parserContext) {
        if (element.hasAttribute(POINTCUT) && element.hasAttribute(POINTCUT_REF)) {
            parserContext.getReaderContext().error("Cannot define both 'pointcut' and 'pointcut-ref' on 'advisor' tag.", element, this.parseState.snapshot());
            return null;
        }
        if (element.hasAttribute(POINTCUT)) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            Attr pointcutAttr = element.getAttributeNode(POINTCUT);
            AbstractBeanDefinition pointcutDefinition = this.createPointcutDefinition(pointcutAttr.getValue());
            pointcutDefinition.setSource(parserContext.extractSource(element));
            String pointcutName = BeanDefinitionReaderUtils.generateBeanName(pointcutDefinition, registry);
            try {
                this.parseState.push(new PointcutEntry(pointcutName));
                registry.registerBeanDefinition(pointcutName, pointcutDefinition);
                mpvs.addPropertyValue(POINTCUT, new RuntimeBeanReference(pointcutName));
            }
            finally {
                this.parseState.pop();
            }
            return pointcutName;
        }
        if (element.hasAttribute(POINTCUT_REF)) {
            String pointcutRef = element.getAttribute(POINTCUT_REF);
            try {
                this.parseState.push(new PointcutEntry(pointcutRef));
                mpvs.addPropertyValue(POINTCUT, new RuntimeBeanReference(pointcutRef));
            }
            finally {
                this.parseState.pop();
            }
            return pointcutRef;
        }
        parserContext.getReaderContext().error("Must define one of 'pointcut' or 'pointcut-ref' on 'advisor'.", element, this.parseState.snapshot());
        return null;
    }

    protected AbstractBeanDefinition createPointcutDefinition(String expression) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(class$org$springframework$aop$aspectj$AspectJExpressionPointcut == null ? (class$org$springframework$aop$aspectj$AspectJExpressionPointcut = ConfigBeanDefinitionParser.class$("com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJExpressionPointcut")) : class$org$springframework$aop$aspectj$AspectJExpressionPointcut);
        beanDefinition.setSingleton(false);
        beanDefinition.setSynthetic(true);
        beanDefinition.getPropertyValues().addPropertyValue(EXPRESSION, expression);
        return beanDefinition;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

