/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.chunking;

import com.bmc.arsys.apitransport.chunking.ARChunkProcessorBase;
import com.bmc.arsys.apitransport.chunking.IARChunkable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ARChunkProcessorFactory {
    private static Logger a = Logger.getLogger(ARChunkProcessorFactory.class);
    protected static List<Integer> receiveChunkingOnOutputParamCallList = new ArrayList<Integer>();
    protected static List<Integer> sendChunkingOnInputParamCallList = new ArrayList<Integer>();
    protected static Map<Integer, Class<?>> registry = new HashMap();

    public static IARChunkable createProcessor(int n2) {
        if (registry.containsKey(n2)) {
            Class<?> clazz = registry.get(n2);
            ARChunkProcessorBase aRChunkProcessorBase = null;
            try {
                aRChunkProcessorBase = (ARChunkProcessorBase)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                a.error("API procedure " + n2 + " is not supprted for chunking.", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                a.error("API procedure " + n2 + " chunking processor does not have public constructor.", illegalAccessException);
            }
            return aRChunkProcessorBase;
        }
        a.error("API procedure " + n2 + " is not supprted for chunking.");
        throw new NullPointerException();
    }

    public static boolean isChunkingSupportedCall(int n2) {
        return receiveChunkingOnOutputParamCallList.contains(n2) || sendChunkingOnInputParamCallList.contains(n2);
    }

    public static boolean isSendChunkingOnInputParamCall(int n2) {
        return sendChunkingOnInputParamCallList.contains(n2);
    }

    public static boolean isReceiveChunkingOnOutputParamCall(int n2) {
        return receiveChunkingOnOutputParamCallList.contains(n2);
    }
}

