/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.multipart.support;

import com.bmc.thirdparty.org.springframework.web.context.WebApplicationContext;
import com.bmc.thirdparty.org.springframework.web.context.support.WebApplicationContextUtils;
import com.bmc.thirdparty.org.springframework.web.filter.OncePerRequestFilter;
import com.bmc.thirdparty.org.springframework.web.multipart.MultipartHttpServletRequest;
import com.bmc.thirdparty.org.springframework.web.multipart.MultipartResolver;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MultipartFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_MULTIPART_RESOLVER_BEAN_NAME = "filterMultipartResolver";
    private String multipartResolverBeanName = "filterMultipartResolver";
    static /* synthetic */ Class class$org$springframework$web$multipart$MultipartResolver;

    public void setMultipartResolverBeanName(String multipartResolverBeanName) {
        this.multipartResolverBeanName = multipartResolverBeanName;
    }

    protected String getMultipartResolverBeanName() {
        return this.multipartResolverBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest processedRequest;
        MultipartResolver multipartResolver = this.lookupMultipartResolver(request);
        if (multipartResolver.isMultipart(processedRequest = request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Resolving multipart request [" + processedRequest.getRequestURI() + "] with MultipartFilter");
            }
            processedRequest = multipartResolver.resolveMultipart(processedRequest);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Request [" + processedRequest.getRequestURI() + "] is not a multipart request");
        }
        try {
            filterChain.doFilter((ServletRequest)processedRequest, (ServletResponse)response);
        }
        finally {
            if (processedRequest instanceof MultipartHttpServletRequest) {
                multipartResolver.cleanupMultipart((MultipartHttpServletRequest)processedRequest);
            }
        }
    }

    protected MultipartResolver lookupMultipartResolver(HttpServletRequest request) {
        return this.lookupMultipartResolver();
    }

    protected MultipartResolver lookupMultipartResolver() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Using MultipartResolver '" + this.getMultipartResolverBeanName() + "' for MultipartFilter");
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext());
        return (MultipartResolver)wac.getBean(this.getMultipartResolverBeanName(), class$org$springframework$web$multipart$MultipartResolver == null ? (class$org$springframework$web$multipart$MultipartResolver = MultipartFilter.class$("com.bmc.thirdparty.org.springframework.web.multipart.MultipartResolver")) : class$org$springframework$web$multipart$MultipartResolver);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

