/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.context.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.context.ApplicationEvent;
import com.bmc.thirdparty.org.springframework.context.ApplicationListener;
import com.bmc.thirdparty.org.springframework.util.ResponseTimeMonitorImpl;
import com.bmc.thirdparty.org.springframework.web.context.support.RequestHandledEvent;

public class PerformanceMonitorListener
implements ApplicationListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ResponseTimeMonitorImpl responseTimeMonitor = new ResponseTimeMonitorImpl();

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof RequestHandledEvent) {
            RequestHandledEvent rhe = (RequestHandledEvent)event;
            this.responseTimeMonitor.recordResponseTime(rhe.getProcessingTimeMillis());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("PerformanceMonitorListener: last=[" + rhe.getProcessingTimeMillis() + "ms]; " + this.responseTimeMonitor + "; " + rhe.getShortDescription());
            }
        }
    }
}

