/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.acplt.oncrpc.ArRpcBindHelper;
import org.acplt.oncrpc.OncRpcBroadcastEvent;
import org.acplt.oncrpc.OncRpcBroadcastListener;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.OncRpcUdpSocketHelper;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrUdpDecodingStream;
import org.acplt.oncrpc.XdrUdpEncodingStream;

public class OncRpcUdpClient
extends OncRpcClient {
    private DatagramSocket socket;
    private OncRpcUdpSocketHelper socketHelper;
    protected XdrUdpEncodingStream sendingXdr;
    protected XdrUdpDecodingStream receivingXdr;
    protected int retransmissionTimeout;
    protected int retransmissionMode;

    public OncRpcUdpClient(InetAddress inetAddress, int n, int n2, int n3) throws OncRpcException, IOException {
        this(inetAddress, n, n2, n3, 8192);
    }

    public OncRpcUdpClient(InetAddress inetAddress, int n, int n2, int n3, int n4) throws OncRpcException, IOException {
        super(inetAddress, n, n2, n3, 17);
        this.retransmissionTimeout = this.timeout;
        this.retransmissionMode = 1;
        if (n4 < 1024) {
            n4 = 1024;
        }
        this.socket = new DatagramSocket();
        this.socketHelper = new OncRpcUdpSocketHelper(this.socket);
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("OncRpcUdpSocket bound " + inetAddress.getHostAddress() + " on port " + n3);
            System.out.println("with DatagramSocket localInetAddress: " + this.socket.getLocalSocketAddress());
        }
        if (this.socketHelper.getSendBufferSize() < n4) {
            this.socketHelper.setSendBufferSize(n4);
        }
        if (this.socketHelper.getReceiveBufferSize() < n4) {
            this.socketHelper.setReceiveBufferSize(n4);
        }
        this.sendingXdr = new XdrUdpEncodingStream(this.socket, n4);
        this.receivingXdr = new XdrUdpDecodingStream(this.socket, n4);
    }

    @Override
    public void close() throws OncRpcException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sendingXdr = null;
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.receivingXdr = null;
        }
    }

    @Override
    public synchronized void call(int n, int n2, XdrAble xdrAble, XdrAble xdrAble2) throws OncRpcException {
        block16: for (int i = 1; i >= 0; --i) {
            this.nextXid();
            OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, n2, n, this.auth);
            OncRpcClientReplyMessage oncRpcClientReplyMessage = new OncRpcClientReplyMessage(this.auth);
            long l = System.currentTimeMillis() + (long)this.timeout;
            int n3 = this.retransmissionTimeout;
            do {
                try {
                    this.sendingXdr.beginEncoding(this.host, this.port);
                    oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
                    xdrAble.xdrEncode(this.sendingXdr);
                    this.sendingXdr.endEncoding();
                }
                catch (IOException iOException) {
                    throw new OncRpcException(3, iOException.getLocalizedMessage());
                }
                if (this.timeout == 0) {
                    return;
                }
                while (true) {
                    block24: {
                        try {
                            int n4 = (int)(l - System.currentTimeMillis());
                            if (n4 > n3) {
                                n4 = n3;
                            } else if (n4 < 0) {
                                n4 = 0;
                            }
                            this.socket.setSoTimeout(n4);
                            this.receivingXdr.beginDecoding();
                            if (!this.host.equals(this.receivingXdr.getSenderAddress())) break block24;
                            try {
                                oncRpcClientReplyMessage.xdrDecode(this.receivingXdr);
                            }
                            catch (OncRpcException oncRpcException) {
                                this.receivingXdr.endDecoding();
                                throw oncRpcException;
                            }
                            if (oncRpcClientReplyMessage.messageId != oncRpcClientCallMessage.messageId) break block24;
                            if (!oncRpcClientReplyMessage.successfullyAccepted()) {
                                this.receivingXdr.endDecoding();
                                if (i > 0 && oncRpcClientReplyMessage.replyStatus == 1 && oncRpcClientReplyMessage.rejectStatus == 1 && this.auth != null && this.auth.canRefreshCred()) continue block16;
                                throw oncRpcClientReplyMessage.newException();
                            }
                            try {
                                xdrAble2.xdrDecode(this.receivingXdr);
                            }
                            catch (OncRpcException oncRpcException) {
                                this.receivingXdr.endDecoding();
                                throw oncRpcException;
                            }
                            this.receivingXdr.endDecoding();
                            return;
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            break;
                        }
                        catch (IOException iOException) {
                            try {
                                this.receivingXdr.endDecoding();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            throw new OncRpcException(4, iOException.getLocalizedMessage());
                        }
                        catch (OncRpcException oncRpcException) {
                            try {
                                this.receivingXdr.endDecoding();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (oncRpcException.getReason() == 44) break block24;
                            throw oncRpcException;
                        }
                    }
                    try {
                        this.receivingXdr.endDecoding();
                    }
                    catch (IOException iOException) {
                        throw new OncRpcException(4, iOException.getLocalizedMessage());
                    }
                }
                if (this.retransmissionMode != 0) continue;
                n3 *= 2;
            } while (System.currentTimeMillis() < l);
            throw new OncRpcTimeoutException();
        }
    }

    public synchronized void broadcastCall(int n, XdrAble xdrAble, XdrAble xdrAble2, OncRpcBroadcastListener oncRpcBroadcastListener) throws OncRpcException {
        this.nextXid();
        OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, this.version, n, this.auth);
        OncRpcClientReplyMessage oncRpcClientReplyMessage = new OncRpcClientReplyMessage(this.auth);
        try {
            this.sendingXdr.beginEncoding(this.host, this.port);
            oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
            xdrAble.xdrEncode(this.sendingXdr);
            this.sendingXdr.endEncoding();
        }
        catch (IOException iOException) {
            throw new OncRpcException(3, iOException.getLocalizedMessage());
        }
        long l = System.currentTimeMillis() + (long)this.timeout;
        do {
            try {
                int n2 = (int)(l - System.currentTimeMillis());
                if (n2 < 0) {
                    n2 = 0;
                }
                this.socket.setSoTimeout(n2);
                this.receivingXdr.beginDecoding();
                oncRpcClientReplyMessage.xdrDecode(this.receivingXdr);
                if (oncRpcClientReplyMessage.messageId == oncRpcClientCallMessage.messageId) {
                    if (!oncRpcClientReplyMessage.successfullyAccepted()) {
                        this.receivingXdr.endDecoding();
                    }
                    xdrAble2.xdrDecode(this.receivingXdr);
                    if (oncRpcBroadcastListener != null) {
                        OncRpcBroadcastEvent oncRpcBroadcastEvent = new OncRpcBroadcastEvent(this, this.receivingXdr.getSenderAddress(), n, xdrAble, xdrAble2);
                        oncRpcBroadcastListener.replyReceived(oncRpcBroadcastEvent);
                    }
                    this.receivingXdr.endDecoding();
                    continue;
                }
                try {
                    this.receivingXdr.endDecoding();
                }
                catch (IOException iOException) {
                    throw new OncRpcException(4, iOException.getLocalizedMessage());
                }
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException iOException) {
                throw new OncRpcException(4, iOException.getLocalizedMessage());
            }
        } while (System.currentTimeMillis() < l);
    }

    public void setRetransmissionMode(int n) {
        this.retransmissionMode = n;
    }

    public int getRetransmissionMode() {
        return this.retransmissionMode;
    }

    public void setRetransmissionTimeout(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("timeouts must be positive.");
        }
        this.retransmissionTimeout = n;
    }

    public int getRetransmissionTimeout() {
        return this.retransmissionTimeout;
    }

    @Override
    public void setCharacterEncoding(String string) {
        this.receivingXdr.setCharacterEncoding(string);
        this.sendingXdr.setCharacterEncoding(string);
    }

    @Override
    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }
}

