/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task;

import java.io.Serializable;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrencyThrottleSupport;

public class SimpleAsyncTaskExecutor
extends ConcurrencyThrottleSupport
implements TaskExecutor,
Serializable {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(class$org$springframework$core$task$SimpleAsyncTaskExecutor == null ? (class$org$springframework$core$task$SimpleAsyncTaskExecutor = SimpleAsyncTaskExecutor.class$("org.springframework.core.task.SimpleAsyncTaskExecutor")) : class$org$springframework$core$task$SimpleAsyncTaskExecutor) + "-";
    private final Object monitor = new Object();
    private String threadNamePrefix = DEFAULT_THREAD_NAME_PREFIX;
    private int threadPriority = 5;
    private boolean daemon = false;
    private int threadCount = 0;
    static /* synthetic */ Class class$org$springframework$core$task$SimpleAsyncTaskExecutor;

    public SimpleAsyncTaskExecutor() {
    }

    public SimpleAsyncTaskExecutor(String threadNamePrefix) {
        this.setThreadNamePrefix(threadNamePrefix);
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix != null ? threadNamePrefix : DEFAULT_THREAD_NAME_PREFIX;
    }

    protected String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    protected int getThreadPriority() {
        return this.threadPriority;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    protected boolean isDaemon() {
        return this.daemon;
    }

    public final void execute(Runnable task) {
        Assert.notNull(task, "Runnable must not be null");
        this.beforeAccess();
        this.doExecute(new ConcurrencyThrottlingRunnable(task));
    }

    protected void doExecute(Runnable task) {
        this.createThread(task).start();
    }

    protected Thread createThread(Runnable task) {
        Thread thread = new Thread(task, this.nextThreadName());
        thread.setPriority(this.getThreadPriority());
        thread.setDaemon(this.isDaemon());
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String nextThreadName() {
        int threadNumber = 0;
        Object object = this.monitor;
        synchronized (object) {
            ++this.threadCount;
            threadNumber = this.threadCount;
        }
        return this.getThreadNamePrefix() + threadNumber;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConcurrencyThrottlingRunnable
    implements Runnable {
        private final Runnable target;

        public ConcurrencyThrottlingRunnable(Runnable target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.target.run();
            }
            finally {
                SimpleAsyncTaskExecutor.this.afterAccess();
            }
        }
    }
}

