/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.handler;

import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.web.context.request.WebRequestInterceptor;
import com.bmc.thirdparty.org.springframework.web.servlet.HandlerInterceptor;
import com.bmc.thirdparty.org.springframework.web.servlet.ModelAndView;
import com.bmc.thirdparty.org.springframework.web.servlet.handler.DispatcherServletWebRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebRequestHandlerInterceptorAdapter
implements HandlerInterceptor {
    private final WebRequestInterceptor requestInterceptor;

    public WebRequestHandlerInterceptorAdapter(WebRequestInterceptor requestInterceptor) {
        Assert.notNull(requestInterceptor, "WebRequestInterceptor must not be null");
        this.requestInterceptor = requestInterceptor;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.requestInterceptor.preHandle(new DispatcherServletWebRequest(request));
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.requestInterceptor.postHandle(new DispatcherServletWebRequest(request), modelAndView != null ? modelAndView.getModelMap() : null);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.requestInterceptor.afterCompletion(new DispatcherServletWebRequest(request), ex);
    }
}

