/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.hibernate3;

import com.bmc.thirdparty.org.springframework.transaction.support.ResourceHolderSupport;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class SessionHolder
extends ResourceHolderSupport {
    private static final Object DEFAULT_KEY = new Object();
    private final Map sessionMap = Collections.synchronizedMap(new HashMap(1));
    private Transaction transaction;
    private FlushMode previousFlushMode;

    public SessionHolder(Session session) {
        this.addSession(session);
    }

    public SessionHolder(Object key, Session session) {
        this.addSession(key, session);
    }

    public Session getSession() {
        return this.getSession(DEFAULT_KEY);
    }

    public Session getSession(Object key) {
        return (Session)this.sessionMap.get(key);
    }

    public Session getValidatedSession() {
        return this.getValidatedSession(DEFAULT_KEY);
    }

    public Session getValidatedSession(Object key) {
        Session session = (Session)this.sessionMap.get(key);
        if (session != null && !session.isOpen()) {
            this.sessionMap.remove(key);
            session = null;
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getAnySession() {
        Map map = this.sessionMap;
        synchronized (map) {
            if (!this.sessionMap.isEmpty()) {
                return (Session)this.sessionMap.values().iterator().next();
            }
            return null;
        }
    }

    public void addSession(Session session) {
        this.addSession(DEFAULT_KEY, session);
    }

    public void addSession(Object key, Session session) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(session, "Session must not be null");
        this.sessionMap.put(key, session);
    }

    public Session removeSession(Object key) {
        return (Session)this.sessionMap.remove(key);
    }

    public boolean containsSession(Session session) {
        return this.sessionMap.containsValue(session);
    }

    public boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesNotHoldNonDefaultSession() {
        Map map = this.sessionMap;
        synchronized (map) {
            return this.sessionMap.isEmpty() || this.sessionMap.size() == 1 && this.sessionMap.containsKey(DEFAULT_KEY);
        }
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setPreviousFlushMode(FlushMode previousFlushMode) {
        this.previousFlushMode = previousFlushMode;
    }

    public FlushMode getPreviousFlushMode() {
        return this.previousFlushMode;
    }

    public void clear() {
        super.clear();
        this.transaction = null;
        this.previousFlushMode = null;
    }
}

