/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.support;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanCreationException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanDefinitionStoreException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactoryUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.CannotLoadBeanClassException;
import com.bmc.thirdparty.org.springframework.beans.factory.NoSuchBeanDefinitionException;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.support.AbstractBeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionValidationException;
import com.bmc.thirdparty.org.springframework.beans.factory.support.RootBeanDefinition;
import com.bmc.thirdparty.org.springframework.core.CollectionFactory;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry {
    private boolean allowBeanDefinitionOverriding = true;
    private boolean allowEagerClassLoading = true;
    private final Map beanDefinitionMap = new HashMap();
    private final List beanDefinitionNames = new ArrayList();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanCurrentlyInCreationException;

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public void setAllowEagerClassLoading(boolean allowEagerClassLoading) {
        this.allowEagerClassLoading = allowEagerClassLoading;
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        super.copyConfigurationFrom(otherFactory);
        if (otherFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory otherListableFactory = (DefaultListableBeanFactory)otherFactory;
            this.allowBeanDefinitionOverriding = otherListableFactory.allowBeanDefinitionOverriding;
            this.allowEagerClassLoading = otherListableFactory.allowEagerClassLoading;
        }
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.beanDefinitionMap.containsKey(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    public String[] getBeanDefinitionNames() {
        return StringUtils.toStringArray(this.beanDefinitionNames);
    }

    public String[] getBeanNamesForType(Class type) {
        return this.getBeanNamesForType(type, true, true);
    }

    public String[] getBeanNamesForType(Class type, boolean includePrototypes, boolean allowEagerInit) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = this.beanDefinitionNames.iterator();
        while (it.hasNext()) {
            RootBeanDefinition rbd;
            String beanName = (String)it.next();
            if (this.isAlias(beanName) || (rbd = this.getMergedBeanDefinition(beanName, false)).isAbstract() || !allowEagerInit && !rbd.hasBeanClass() && rbd.isLazyInit() && !this.allowEagerClassLoading) continue;
            try {
                boolean isFactoryBean;
                Class beanClass = this.resolveBeanClass(rbd, beanName);
                boolean bl = beanClass != null && (class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("com.bmc.thirdparty.org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass) ? true : (isFactoryBean = false);
                if (isFactoryBean || rbd.getFactoryBeanName() != null) {
                    if (allowEagerInit && (includePrototypes || this.isSingleton(beanName)) && this.isBeanTypeMatch(beanName, type)) {
                        result.add(beanName);
                        continue;
                    }
                    if (!isFactoryBean) continue;
                    beanName = "&" + beanName;
                }
                if (!includePrototypes && !rbd.isSingleton() || !this.isBeanTypeMatch(beanName, type)) continue;
                result.add(beanName);
            }
            catch (CannotLoadBeanClassException ex) {
                if (rbd.isLazyInit()) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Ignoring bean class loading failure for lazy-init bean '" + beanName + "'", ex);
                    continue;
                }
                throw ex;
            }
        }
        String[] singletonNames = this.getSingletonNames();
        for (int i2 = 0; i2 < singletonNames.length; ++i2) {
            String beanName = singletonNames[i2];
            if (this.containsBeanDefinition(beanName)) continue;
            if (this.isFactoryBean(beanName)) {
                if ((includePrototypes || this.isSingleton(beanName)) && this.isBeanTypeMatch(beanName, type)) {
                    result.add(beanName);
                    continue;
                }
                beanName = "&" + beanName;
            }
            if (!this.isBeanTypeMatch(beanName, type)) continue;
            result.add(beanName);
        }
        return StringUtils.toStringArray(result);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean allowEagerInit) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(type, includePrototypes, allowEagerInit);
        Map result = CollectionFactory.createLinkedMapIfPossible(beanNames.length);
        for (int i2 = 0; i2 < beanNames.length; ++i2) {
            String beanName = beanNames[i2];
            try {
                result.put(beanName, this.getBean(beanName));
                continue;
            }
            catch (BeanCreationException ex) {
                if (ex.contains(class$org$springframework$beans$factory$BeanCurrentlyInCreationException == null ? DefaultListableBeanFactory.class$("com.bmc.thirdparty.org.springframework.beans.factory.BeanCurrentlyInCreationException") : class$org$springframework$beans$factory$BeanCurrentlyInCreationException)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Ignoring match to currently created bean '" + beanName + "': " + ex.getMessage());
                    continue;
                }
                throw ex;
            }
        }
        return result;
    }

    private boolean isBeanTypeMatch(String beanName, Class type) {
        if (type == null) {
            return true;
        }
        Class beanType = this.getType(beanName);
        return beanType != null && type.isAssignableFrom(beanType);
    }

    public void preInstantiateSingletons() throws BeansException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Pre-instantiating singletons in factory [" + this + "]");
        }
        Iterator it = this.beanDefinitionNames.iterator();
        while (it.hasNext()) {
            RootBeanDefinition bd;
            String beanName = (String)it.next();
            if (this.containsSingleton(beanName) || !this.containsBeanDefinition(beanName) || (bd = this.getMergedBeanDefinition(beanName, false)).isAbstract() || !bd.isSingleton() || bd.isLazyInit()) continue;
            Class beanClass = this.resolveBeanClass(bd, beanName);
            if (beanClass != null && (class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("com.bmc.thirdparty.org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass)) {
                this.getBean("&" + beanName);
                continue;
            }
            this.getBean(beanName);
        }
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        Object oldBeanDefinition;
        Assert.hasText(beanName, "Bean name must not be empty");
        Assert.notNull(beanDefinition, "Bean definition must not be null");
        if (beanDefinition instanceof AbstractBeanDefinition) {
            try {
                ((AbstractBeanDefinition)beanDefinition).validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Validation of bean definition failed", (Throwable)ex);
            }
        }
        if ((oldBeanDefinition = this.beanDefinitionMap.get(beanName)) != null) {
            if (!this.allowBeanDefinitionOverriding) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Cannot register bean definition [" + beanDefinition + "] for bean '" + beanName + "': there's already [" + oldBeanDefinition + "] bound");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Overriding bean definition for bean '" + beanName + "': replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]");
            }
        } else {
            this.beanDefinitionNames.add(beanName);
        }
        this.beanDefinitionMap.put(beanName, beanDefinition);
        this.removeSingleton(beanName);
    }

    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        BeanDefinition bd = (BeanDefinition)this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No bean named '" + beanName + "' found in " + this.toString());
            }
            throw new NoSuchBeanDefinitionException(beanName);
        }
        return bd;
    }

    protected Map findMatchingBeans(Class requiredType) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors(this, requiredType);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(" defining beans [");
        sb.append(StringUtils.arrayToDelimitedString(this.getBeanDefinitionNames(), ","));
        sb.append("]; ");
        if (this.getParentBeanFactory() == null) {
            sb.append("root of BeanFactory hierarchy");
        } else {
            sb.append("parent: " + this.getParentBeanFactory());
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

