/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans;

import com.bmc.thirdparty.org.springframework.beans.PropertyAccessException;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.beans.PropertyChangeEvent;

public class TypeMismatchException
extends PropertyAccessException {
    public static final String ERROR_CODE = "typeMismatch";
    private Object value;
    private Class requiredType;

    public TypeMismatchException(PropertyChangeEvent propertyChangeEvent, Class requiredType) {
        this(propertyChangeEvent, requiredType, null);
    }

    public TypeMismatchException(PropertyChangeEvent propertyChangeEvent, Class requiredType, Throwable cause) {
        super(propertyChangeEvent, "Failed to convert property value of type [" + (propertyChangeEvent.getNewValue() != null ? ClassUtils.getQualifiedName(propertyChangeEvent.getNewValue().getClass()) : null) + "]" + (requiredType != null ? " to required type [" + ClassUtils.getQualifiedName(requiredType) + "]" : "") + (propertyChangeEvent.getPropertyName() != null ? " for property '" + propertyChangeEvent.getPropertyName() + "'" : ""), cause);
        this.value = propertyChangeEvent.getNewValue();
        this.requiredType = requiredType;
    }

    public TypeMismatchException(Object value, Class requiredType) {
        this(value, requiredType, null);
    }

    public TypeMismatchException(Object value, Class requiredType, Throwable cause) {
        super("Failed to convert value of type [" + (value != null ? ClassUtils.getQualifiedName(value.getClass()) : null) + "]" + (requiredType != null ? " to required type [" + ClassUtils.getQualifiedName(requiredType) + "]" : ""), cause);
        this.value = value;
        this.requiredType = requiredType;
    }

    public Object getValue() {
        return this.value;
    }

    public Class getRequiredType() {
        return this.requiredType;
    }

    public String getErrorCode() {
        return ERROR_CODE;
    }
}

