/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.aspectj.annotation;

import com.bmc.thirdparty.org.springframework.aop.Advisor;
import com.bmc.thirdparty.org.springframework.aop.aspectj.AspectJProxyUtils;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.AspectMetadata;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.PrototypeAspectInstanceFactory;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.ReflectiveAspectJAdvisorFactory;
import com.bmc.thirdparty.org.springframework.aop.aspectj.annotation.SingletonMetadataAwareAspectInstanceFactory;
import com.bmc.thirdparty.org.springframework.aop.framework.AdvisedSupport;
import com.bmc.thirdparty.org.springframework.aop.framework.AopConfigException;
import com.bmc.thirdparty.org.springframework.beans.BeanUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.support.DefaultListableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.support.RootBeanDefinition;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.reflect.PerClauseKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectJProxyFactory
extends AdvisedSupport {
    private final AspectJAdvisorFactory aspectFactory = new ReflectiveAspectJAdvisorFactory();
    private static final Map aspectCache = new HashMap();

    public AspectJProxyFactory() {
    }

    public AspectJProxyFactory(Object target) throws AopConfigException {
        Assert.notNull(target, "'target' cannot be null.");
        this.setInterfaces(ClassUtils.getAllInterfaces(target));
        this.setTarget(target);
    }

    public AspectJProxyFactory(Class[] interfaces) {
        this.setInterfaces(interfaces);
    }

    public <T> T getProxy() {
        return (T)this.createAopProxy().getProxy();
    }

    public <T> T getProxy(ClassLoader classLoader) {
        return (T)this.createAopProxy().getProxy(classLoader);
    }

    public void addAspect(Object aspect) {
        String beanName;
        Class<?> aspectType = aspect.getClass();
        AspectMetadata am = this.createAspectMetadata(aspectType, beanName = aspectType.getName());
        if (am.getAjType().getPerClause().getKind() != PerClauseKind.SINGLETON) {
            throw new IllegalArgumentException("Aspect type '" + aspectType.getName() + "' is not a singleton aspect.");
        }
        SingletonMetadataAwareAspectInstanceFactory instanceFactory = new SingletonMetadataAwareAspectInstanceFactory(aspect, beanName);
        this.addAdvisorsFromAspectInstanceFactory(instanceFactory);
    }

    public void addAspect(Class aspectType) {
        String beanName = aspectType.getName();
        AspectMetadata am = this.createAspectMetadata(aspectType, beanName);
        MetadataAwareAspectInstanceFactory instanceFactory = this.createAspectInstanceFactory(am, aspectType, beanName);
        this.addAdvisorsFromAspectInstanceFactory(instanceFactory);
    }

    private void addAdvisorsFromAspectInstanceFactory(MetadataAwareAspectInstanceFactory instanceFactory) {
        List<Advisor> advisors = this.aspectFactory.getAdvisors(instanceFactory);
        this.addAllAdvisors(advisors.toArray(new Advisor[advisors.size()]));
        this.makeAdvisorChainAspectJCapableIfNecessary();
    }

    private AspectMetadata createAspectMetadata(Class aspectType, String beanName) {
        AspectMetadata am = new AspectMetadata(aspectType, beanName);
        if (!am.getAjType().isAspect()) {
            throw new IllegalArgumentException("Class '" + aspectType.getName() + "' is not a valid aspect type.");
        }
        return am;
    }

    private MetadataAwareAspectInstanceFactory createAspectInstanceFactory(AspectMetadata am, Class aspectType, String beanName) {
        MetadataAwareAspectInstanceFactory instanceFactory = null;
        if (am.getAjType().getPerClause().getKind() == PerClauseKind.SINGLETON) {
            Object instance = this.getSingletonAspectInstance(aspectType);
            instanceFactory = new SingletonMetadataAwareAspectInstanceFactory(instance, beanName);
        } else {
            DefaultListableBeanFactory bf = this.getPrototypeAspectBeanFactory(aspectType, beanName);
            instanceFactory = new PrototypeAspectInstanceFactory(bf, beanName);
        }
        return instanceFactory;
    }

    private void makeAdvisorChainAspectJCapableIfNecessary() {
        if (AspectJProxyUtils.makeAdvisorChainAspectJCapableIfNecessary(this.getAdvisorsInternal())) {
            this.updateAdvisorArray();
            this.adviceChanged();
        }
    }

    private DefaultListableBeanFactory getPrototypeAspectBeanFactory(Class aspectType, String beanName) {
        DefaultListableBeanFactory bf = new DefaultListableBeanFactory();
        RootBeanDefinition definition = new RootBeanDefinition(aspectType);
        definition.setSingleton(false);
        bf.registerBeanDefinition(beanName, definition);
        return bf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSingletonAspectInstance(Class aspectType) {
        Map map = aspectCache;
        synchronized (map) {
            Object instance = aspectCache.get(aspectType);
            if (instance != null) {
                return instance;
            }
            instance = BeanUtils.instantiateClass(aspectType);
            aspectCache.put(aspectType, instance);
            return instance;
        }
    }
}

