/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.hibernate3;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.springframework.orm.hibernate3.HibernateAccessor;
import com.bmc.thirdparty.org.springframework.orm.hibernate3.SessionFactoryUtils;
import com.bmc.thirdparty.org.springframework.orm.hibernate3.SessionHolder;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationManager;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class HibernateInterceptor
extends HibernateAccessor
implements MethodInterceptor {
    private boolean exceptionConversionEnabled = true;

    public void setExceptionConversionEnabled(boolean exceptionConversionEnabled) {
        this.exceptionConversionEnabled = exceptionConversionEnabled;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Session session = this.getSession();
        boolean existingTransaction = SessionFactoryUtils.isSessionTransactional(session, this.getSessionFactory());
        if (existingTransaction) {
            this.logger.debug("Found thread-bound Session for HibernateInterceptor");
        } else {
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(session));
        }
        FlushMode previousFlushMode = null;
        try {
            previousFlushMode = this.applyFlushMode(session, existingTransaction);
            this.enableFilters(session);
            Object retVal = methodInvocation.proceed();
            this.flushIfNecessary(session, existingTransaction);
            Object object = retVal;
            return object;
        }
        catch (HibernateException ex) {
            if (this.exceptionConversionEnabled) {
                throw this.convertHibernateAccessException(ex);
            }
            throw ex;
        }
        finally {
            if (existingTransaction) {
                this.logger.debug("Not closing pre-bound Hibernate Session after HibernateInterceptor");
                this.disableFilters(session);
                if (previousFlushMode != null) {
                    session.setFlushMode(previousFlushMode);
                }
            } else {
                TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
                SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.getSessionFactory());
            }
        }
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
    }
}

