/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.jdbc.CannotGetJdbcConnectionException;
import com.bmc.thirdparty.org.springframework.jdbc.datasource.DataSourceUtils;
import com.bmc.thirdparty.org.springframework.jdbc.support.DatabaseMetaDataCallback;
import com.bmc.thirdparty.org.springframework.jdbc.support.MetaDataAccessException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public abstract class JdbcUtils {
    public static final int TYPE_UNKNOWN = Integer.MIN_VALUE;
    private static final Log logger = LogFactory.getLog(class$org$springframework$jdbc$support$JdbcUtils == null ? (class$org$springframework$jdbc$support$JdbcUtils = JdbcUtils.class$("com.bmc.thirdparty.org.springframework.jdbc.support.JdbcUtils")) : class$org$springframework$jdbc$support$JdbcUtils);
    static /* synthetic */ Class class$org$springframework$jdbc$support$JdbcUtils;

    public static void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                logger.debug("Could not close JDBC Connection", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing JDBC Connection", ex);
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                logger.debug("Could not close JDBC Statement", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing JDBC Statement", ex);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                logger.debug("Could not close JDBC ResultSet", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing JDBC ResultSet", ex);
            }
        }
    }

    public static Object getResultSetValue(ResultSet rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        if (obj instanceof Blob) {
            obj = rs.getBytes(index);
        } else if (obj instanceof Clob) {
            obj = rs.getString(index);
        } else if (obj != null && obj.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
            obj = rs.getTimestamp(index);
        } else if (obj != null && obj.getClass().getName().startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
        } else if (obj != null && obj instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
            obj = rs.getTimestamp(index);
        }
        return obj;
    }

    public static Object extractDatabaseMetaData(DataSource dataSource, DatabaseMetaDataCallback action) throws MetaDataAccessException {
        Connection con = null;
        try {
            con = DataSourceUtils.getConnection(dataSource);
            if (con == null) {
                throw new MetaDataAccessException("Connection returned by DataSource [" + dataSource + "] was null");
            }
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData == null) {
                throw new MetaDataAccessException("DatabaseMetaData returned by Connection [" + con + "] was null");
            }
            Object object = action.processMetaData(metaData);
            return object;
        }
        catch (CannotGetJdbcConnectionException ex) {
            throw new MetaDataAccessException("Could not get Connection for extracting meta data", ex);
        }
        catch (SQLException ex) {
            throw new MetaDataAccessException("Error while extracting DatabaseMetaData", ex);
        }
        catch (AbstractMethodError err) {
            throw new MetaDataAccessException("JDBC DatabaseMetaData method not implemented by JDBC driver - upgrade your driver", err);
        }
        finally {
            DataSourceUtils.releaseConnection(con, dataSource);
        }
    }

    public static Object extractDatabaseMetaData(DataSource dataSource, final String metaDataMethodName) throws MetaDataAccessException {
        return JdbcUtils.extractDatabaseMetaData(dataSource, new DatabaseMetaDataCallback(){

            public Object processMetaData(DatabaseMetaData dbmd) throws SQLException, MetaDataAccessException {
                try {
                    Method method = dbmd.getClass().getMethod(metaDataMethodName, null);
                    return method.invoke((Object)dbmd, (Object[])null);
                }
                catch (NoSuchMethodException ex) {
                    throw new MetaDataAccessException("No method named '" + metaDataMethodName + "' found on DatabaseMetaData instance [" + dbmd + "]", ex);
                }
                catch (IllegalAccessException ex) {
                    throw new MetaDataAccessException("Could not access DatabaseMetaData method '" + metaDataMethodName + "'", ex);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof SQLException) {
                        throw (SQLException)ex.getTargetException();
                    }
                    throw new MetaDataAccessException("Invocation of DatabaseMetaData method '" + metaDataMethodName + "' failed", ex);
                }
            }
        });
    }

    public static boolean supportsBatchUpdates(Connection con) {
        try {
            DatabaseMetaData dbmd = con.getMetaData();
            if (dbmd != null) {
                if (dbmd.supportsBatchUpdates()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("JDBC driver supports batch updates");
                    }
                    return true;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("JDBC driver does not support batch updates");
                }
            }
        }
        catch (SQLException ex) {
            logger.warn("JDBC driver 'supportsBatchUpdates' method threw exception", ex);
        }
        catch (AbstractMethodError err) {
            logger.warn("JDBC driver does not support JDBC 2.0 'supportsBatchUpdates' method", err);
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

