/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import org.acplt.oncrpc.ArRpcBindHelper;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpSocketHelper;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;

public class OncRpcTcpClient
extends OncRpcClient {
    private static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS");
    private static PrintWriter debugout = null;
    private Socket socket;
    private OncRpcTcpSocketHelper socketHelper;
    protected XdrTcpEncodingStream sendingXdr;
    protected XdrTcpDecodingStream receivingXdr;
    protected int transmissionTimeout = 30000;

    public OncRpcTcpClient(InetAddress inetAddress, int n2, int n3) throws OncRpcException, IOException {
        this(inetAddress, n2, n3, 0, 0);
    }

    public OncRpcTcpClient(InetAddress inetAddress, int n2, int n3, int n4) throws OncRpcException, IOException {
        this(inetAddress, n2, n3, n4, 0);
    }

    public OncRpcTcpClient(InetAddress inetAddress, int n2, int n3, int n4, int n5) throws OncRpcException, IOException {
        this(inetAddress, n2, n3, n4, n5, -1);
    }

    public OncRpcTcpClient(InetAddress inetAddress, int n2, int n3, int n4, int n5, int n6) throws OncRpcException, IOException {
        super(inetAddress, n2, n3, n4, 6);
        if (n5 == 0) {
            n5 = 8192;
        }
        if (n5 < 1024) {
            n5 = 1024;
        }
        this.socketHelper = new OncRpcTcpSocketHelper();
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("client will connect to " + inetAddress + ":" + this.port);
        }
        this.socket = this.socketHelper.connect(inetAddress, this.port, n6);
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("client bound to " + this.socket);
            System.out.println("with localInetAddress: " + this.socket.getLocalSocketAddress() + "; remoteInetAddress: " + this.socket.getRemoteSocketAddress());
        }
        this.socket.setTcpNoDelay(true);
        if (this.socketHelper.getSendBufferSize() < n5) {
            this.socketHelper.setSendBufferSize(n5);
        }
        if (this.socketHelper.getReceiveBufferSize() < n5) {
            this.socketHelper.setReceiveBufferSize(n5);
        }
        this.sendingXdr = this.aNewXdrTcpEncodingStream(null, this.socket, n5);
        this.receivingXdr = this.aNewXdrTcpDecodingStream(null, this.socket, n5);
    }

    @Override
    public void close() throws OncRpcException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sendingXdr = null;
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.receivingXdr = null;
        }
    }

    @Override
    public synchronized void call(int n2, int n3, XdrAble xdrAble, XdrAble xdrAble2) throws OncRpcException {
        for (int i2 = 1; i2 >= 0; --i2) {
            String string;
            this.nextXid();
            OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, n3, n2, this.auth);
            OncRpcClientReplyMessage oncRpcClientReplyMessage = new OncRpcClientReplyMessage(this.auth);
            try {
                if (debugout != null) {
                    string = "call: ProcNumber=" + n2 + " Sending...." + " msgId=" + this.xid;
                    string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
                    debugout.println(string);
                }
                this.socket.setSoTimeout(this.transmissionTimeout);
                this.beginEncoding(n2, null, 0);
                oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
                this.encodeParams(xdrAble);
                if (this.timeout != 0) {
                    this.sendingXdr.endEncoding();
                } else {
                    this.sendingXdr.endEncoding(false);
                }
            }
            catch (IOException iOException) {
                throw new OncRpcException(3, iOException.getLocalizedMessage());
            }
            finally {
                try {
                    this.endEncoding(n2);
                }
                catch (IOException iOException) {
                    throw new OncRpcException(3, iOException.getLocalizedMessage());
                }
            }
            if (this.timeout == 0) {
                return;
            }
            try {
                if (debugout != null) {
                    string = "call: ProcNumber=" + n2 + " Receiving....";
                    string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
                    debugout.println(string);
                }
                while (true) {
                    this.socket.setSoTimeout(this.timeout);
                    this.beginDecoding(n2);
                    this.socket.setSoTimeout(this.transmissionTimeout);
                    try {
                        oncRpcClientReplyMessage.xdrDecode(this.receivingXdr);
                    }
                    catch (OncRpcException oncRpcException) {
                        this.receivingXdr.endDecoding();
                        throw oncRpcException;
                    }
                    if (debugout != null) {
                        string = "call: ProcNumber=" + n2 + " Received msgId=" + oncRpcClientReplyMessage.messageId;
                        string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
                        debugout.println(string);
                    }
                    if (oncRpcClientReplyMessage.messageId == oncRpcClientCallMessage.messageId) break;
                    if (debugout != null) {
                        string = "call: ProcNumber=" + n2 + " mismatched msgId. try again!";
                        string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
                        debugout.println(string);
                    }
                    this.receivingXdr.endDecoding();
                }
                if (!oncRpcClientReplyMessage.successfullyAccepted()) {
                    this.receivingXdr.endDecoding();
                    if (i2 > 0 && oncRpcClientReplyMessage.replyStatus == 1 && oncRpcClientReplyMessage.rejectStatus == 1 && this.auth != null && this.auth.canRefreshCred()) continue;
                    throw oncRpcClientReplyMessage.newException();
                }
                try {
                    this.decodeResult(xdrAble2);
                }
                catch (OncRpcException oncRpcException) {
                    this.receivingXdr.endDecoding();
                    throw oncRpcException;
                }
                this.receivingXdr.endDecoding();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new OncRpcTimeoutException();
            }
            catch (IOException iOException) {
                throw new OncRpcException(4, iOException.getLocalizedMessage());
            }
            finally {
                try {
                    this.endDecoding(n2);
                }
                catch (IOException iOException) {
                    throw new OncRpcException(4, iOException.getLocalizedMessage());
                }
            }
        }
    }

    public synchronized void batchCall(int n2, XdrAble xdrAble, boolean bl) throws OncRpcException {
        this.nextXid();
        OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, this.version, n2, this.auth);
        try {
            this.socket.setSoTimeout(this.transmissionTimeout);
            this.beginEncoding(n2, null, 0);
            oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
            xdrAble.xdrEncode(this.sendingXdr);
            this.sendingXdr.endEncoding(bl);
        }
        catch (IOException iOException) {
            throw new OncRpcException(3, iOException.getLocalizedMessage());
        }
        finally {
            try {
                this.endEncoding(n2);
            }
            catch (IOException iOException) {
                throw new OncRpcException(3, iOException.getLocalizedMessage());
            }
        }
    }

    @Override
    public void setTimeout(int n2) {
        super.setTimeout(n2);
    }

    public void setTransmissionTimeout(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = n2;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    @Override
    public void setCharacterEncoding(String string) {
        this.receivingXdr.setCharacterEncoding(string);
        this.sendingXdr.setCharacterEncoding(string);
    }

    @Override
    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void encodeParams(XdrAble xdrAble) throws OncRpcException, IOException {
        xdrAble.xdrEncode(this.sendingXdr);
    }

    public void decodeResult(XdrAble xdrAble) throws OncRpcException, IOException {
        xdrAble.xdrDecode(this.receivingXdr);
    }

    protected OncRpcTcpSocketHelper getSocketHelper() {
        return this.socketHelper;
    }

    protected void beginDecoding(int n2) throws IOException, OncRpcException {
        this.receivingXdr.beginDecoding();
    }

    protected void endDecoding(int n2) throws IOException, OncRpcException {
    }

    protected void beginEncoding(int n2, InetAddress inetAddress, int n3) throws IOException, OncRpcException {
        this.sendingXdr.beginEncoding(inetAddress, n3);
    }

    protected void endEncoding(int n2) throws IOException, OncRpcException {
    }

    protected XdrTcpEncodingStream aNewXdrTcpEncodingStream(Object object, Socket socket, int n2) throws IOException {
        this.sendingXdr = new XdrTcpEncodingStream(socket, n2);
        return this.sendingXdr;
    }

    protected XdrTcpDecodingStream aNewXdrTcpDecodingStream(Object object, Socket socket, int n2) throws IOException {
        this.receivingXdr = new XdrTcpDecodingStream(socket, n2);
        return this.receivingXdr;
    }
}

