/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.net.Inet6Address;
import java.net.InetAddress;
import org.acplt.oncrpc.ArRpcBindInet6;
import org.acplt.oncrpc.OncRpcGetPortResult;
import org.acplt.oncrpc.OncRpcServerIdent;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBoolean;
import org.acplt.oncrpc.XdrString;

public class ArRpcBindHelper {
    public static final int IPV6_BIT = 1;
    public static final int IPV4_BIT = 2;
    public static final String serverName_IPv4 = "127.0.0.1";
    public static final String serverName_IPv6 = "::1";
    public static final String serverName_LOCALHOST = "localhost";
    public static String tcp6_netid;
    public static String udp6_netid;
    public static String owner;
    public static boolean serverName_LOCALHOST_SERVER;
    public static final int SERVER_TCP_MIN_VER = 1;
    public static final int SERVER_TCP6_MIN_VER = 20;
    public static final int PLUGINSVR_TCP_MIN_VER = 1;
    public static final int PLUGINSVR_TCP6_MIN_VER = 4;
    public static Boolean rpcbind_client_debug;
    public static final int PMAP_VERSION = 4;
    public static int server_min_api_ver;

    static XdrAble getRpcBindRequestParams(InetAddress inetAddress, int n2, int n3, int n4, int n5, int n6) {
        if (inetAddress instanceof Inet6Address) {
            return new ArRpcBindInet6(inetAddress, n3, n4, n5, n6);
        }
        if (serverName_LOCALHOST_SERVER) {
            return new ArRpcBindInet6(inetAddress, n3, n4, n5, n6);
        }
        return new OncRpcServerIdent(n3, n4, n5, n6);
    }

    static XdrAble getRpcBindResponseParams(InetAddress inetAddress, int n2, boolean bl) {
        if (n2 == 3) {
            if (inetAddress instanceof Inet6Address) {
                return new XdrString();
            }
            if (serverName_LOCALHOST_SERVER) {
                return new XdrString();
            }
            return new OncRpcGetPortResult();
        }
        return new XdrBoolean(bl);
    }

    static int getPort(String string) {
        String[] stringArray;
        int n2 = 0;
        if (string != null && string.length() > 0 && (stringArray = string.split("\\.")).length > 2) {
            try {
                int n3 = Integer.parseInt(stringArray[stringArray.length - 2]) << 8;
                int n4 = Integer.parseInt(stringArray[stringArray.length - 1]);
                n2 = n3 + n4;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public static int getRpcBindTryStopVersion(int n2) {
        int n3 = n2;
        if (n2 == 4) {
            --n3;
        }
        return n3;
    }

    public static int getServerMinVersionToRegisger(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return 20;
        }
        if (server_min_api_ver > 0) {
            return server_min_api_ver;
        }
        return 1;
    }

    public static int getPluginSvrMinVersionToRegisger(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return 4;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String string;
        tcp6_netid = "tcp6";
        udp6_netid = "upd6";
        owner = "bmc";
        serverName_LOCALHOST_SERVER = false;
        rpcbind_client_debug = false;
        server_min_api_ver = -1;
        try {
            string = System.getProperty("rpcbind_client_debug");
            if (string != null && string.length() > 0 && (rpcbind_client_debug = Boolean.valueOf("true".equalsIgnoreCase(string))).booleanValue()) {
                System.out.println("system property : rpcbind_client_debug = " + rpcbind_client_debug);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = System.getProperty("server_min_api_ver");
            if (string != null && string.length() > 0) {
                server_min_api_ver = Integer.valueOf(string);
                if (rpcbind_client_debug.booleanValue()) {
                    System.out.println("system property : server_min_api_ver = " + server_min_api_ver);
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (server_min_api_ver == -1) {
                server_min_api_ver = 0;
            }
        }
        try {
            string = System.getProperty("tcp6_netid");
            if (string != null && string.length() > 0) {
                tcp6_netid = string;
                if (rpcbind_client_debug.booleanValue()) {
                    System.out.println("system property : rpc6_netid = " + tcp6_netid);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = System.getProperty("udp6_netid");
            if (string != null && string.length() > 0) {
                udp6_netid = string;
                if (rpcbind_client_debug.booleanValue()) {
                    System.out.println("system property : udp6_netid = " + udp6_netid);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = System.getProperty("owner");
            if (string != null && string.length() > 0) {
                owner = string;
                if (rpcbind_client_debug.booleanValue()) {
                    System.out.println("system property : owner = " + owner);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

