/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.handler;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.util.AntPathMatcher;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.PathMatcher;
import com.bmc.thirdparty.org.springframework.web.servlet.HandlerMapping;
import com.bmc.thirdparty.org.springframework.web.servlet.handler.AbstractHandlerMapping;
import com.bmc.thirdparty.org.springframework.web.util.UrlPathHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private boolean lazyInitHandlers;
    private final Map handlerMap = new HashMap();

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull(pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        String lookupPath = this.urlPathHelper.getLookupPathForRequest(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking up handler for [" + lookupPath + "]");
        }
        return this.lookupHandler(lookupPath, request);
    }

    protected Object lookupHandler(String urlPath, HttpServletRequest request) {
        Object handler = this.handlerMap.get(urlPath);
        if (handler == null) {
            String bestPathMatch = null;
            Iterator it = this.handlerMap.keySet().iterator();
            while (it.hasNext()) {
                String registeredPath = (String)it.next();
                if (!this.pathMatcher.match(registeredPath, urlPath) || bestPathMatch != null && bestPathMatch.length() > registeredPath.length()) continue;
                handler = this.handlerMap.get(registeredPath);
                bestPathMatch = registeredPath;
            }
            if (handler != null) {
                this.exposePathWithinMapping(this.pathMatcher.extractPathWithinPattern(bestPathMatch, urlPath), request);
            }
        } else {
            this.exposePathWithinMapping(urlPath, request);
        }
        return handler;
    }

    protected void exposePathWithinMapping(String pathWithinMapping, HttpServletRequest request) {
        request.setAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, (Object)pathWithinMapping);
    }

    protected void registerHandler(String[] urlPaths, String beanName) throws BeansException, IllegalStateException {
        Assert.notNull(urlPaths, "URL path array must not be null");
        for (int j2 = 0; j2 < urlPaths.length; ++j2) {
            this.registerHandler(urlPaths[j2], (Object)beanName);
        }
    }

    protected void registerHandler(String urlPath, Object handler) throws BeansException, IllegalStateException {
        Assert.notNull(urlPath, "URL path must not be null");
        Assert.notNull(handler, "Handler object must not be null");
        Object mappedHandler = this.handlerMap.get(urlPath);
        if (mappedHandler != null) {
            throw new IllegalStateException("Cannot map handler [" + handler + "] to URL path [" + urlPath + "]: There's already handler [" + mappedHandler + "] mapped.");
        }
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.getApplicationContext().isSingleton(handlerName)) {
                handler = this.getApplicationContext().getBean(handlerName);
            }
        }
        if (urlPath.equals("/*")) {
            this.setDefaultHandler(handler);
        } else {
            this.handlerMap.put(urlPath, handler);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Mapped URL path [" + urlPath + "] onto handler [" + handler + "]");
            }
        }
    }
}

