/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scripting.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.XThis;
import com.bmc.thirdparty.org.springframework.core.NestedRuntimeException;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class BshScriptUtils {
    public static Object createBshObject(String scriptSource, Class[] interfaces) throws EvalError {
        Assert.hasText(scriptSource, "Script source must not be empty");
        Assert.notEmpty(interfaces, "At least one script interface is required");
        Interpreter interpreter = new Interpreter();
        interpreter.eval(scriptSource);
        XThis xt = (XThis)interpreter.eval("return this");
        return Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), interfaces, (InvocationHandler)new BshObjectInvocationHandler(xt));
    }

    public static class BshExecutionException
    extends NestedRuntimeException {
        private BshExecutionException(EvalError ex) {
            super("BeanShell script execution failed", ex);
        }
    }

    private static class BshObjectInvocationHandler
    implements InvocationHandler {
        private final XThis xt;

        public BshObjectInvocationHandler(XThis xt) {
            this.xt = xt;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object result = this.xt.invokeMethod(method.getName(), args);
                if (result == Primitive.NULL || result == Primitive.VOID) {
                    return null;
                }
                if (result instanceof Primitive) {
                    return ((Primitive)result).getValue();
                }
                return result;
            }
            catch (EvalError ex) {
                throw new BshExecutionException(ex);
            }
        }
    }
}

