/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.instrument.classloading;

import com.bmc.thirdparty.org.springframework.instrument.classloading.ShadowingClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceOverridingShadowingClassLoader
extends ShadowingClassLoader {
    private static final Enumeration<URL> EMPTY_URL_ENUMERATION = new Enumeration<URL>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            throw new UnsupportedOperationException("Should not be called. I am empty");
        }
    };
    private Map<String, String> overrides = new HashMap<String, String>();

    public ResourceOverridingShadowingClassLoader(ClassLoader loader) {
        super(loader);
    }

    public void override(String oldPath, String newPath) {
        this.overrides.put(oldPath, newPath);
    }

    public void suppress(String oldPath) {
        this.overrides.put(oldPath, null);
    }

    public void copyOverrides(ResourceOverridingShadowingClassLoader other) {
        this.overrides.putAll(other.overrides);
    }

    @Override
    public URL getResource(String requestedPath) {
        if (this.overrides.containsKey(requestedPath)) {
            String overriddenPath = this.overrides.get(requestedPath);
            return overriddenPath == null ? null : super.getResource(overriddenPath);
        }
        return super.getResource(requestedPath);
    }

    @Override
    public InputStream getResourceAsStream(String requestedPath) {
        if (this.overrides.containsKey(requestedPath)) {
            String overriddenPath = this.overrides.get(requestedPath);
            return overriddenPath == null ? null : super.getResourceAsStream(overriddenPath);
        }
        return super.getResourceAsStream(requestedPath);
    }

    @Override
    public Enumeration<URL> getResources(String requestedPath) throws IOException {
        if (this.overrides.containsKey(requestedPath)) {
            String overriddenLocation = this.overrides.get(requestedPath);
            return overriddenLocation == null ? EMPTY_URL_ENUMERATION : super.getResources(overriddenLocation);
        }
        return super.getResources(requestedPath);
    }
}

