/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;

public abstract class OncRpcServerTransport {
    protected OncRpcDispatchable dispatcher;
    protected int port;
    protected OncRpcServerTransportRegistrationInfo[] info;

    protected OncRpcServerTransport(OncRpcDispatchable oncRpcDispatchable, int n2, OncRpcServerTransportRegistrationInfo[] oncRpcServerTransportRegistrationInfoArray) {
        this.dispatcher = oncRpcDispatchable;
        this.port = n2;
        this.info = oncRpcServerTransportRegistrationInfoArray;
    }

    public abstract void register() throws OncRpcException;

    public void unregister() throws OncRpcException {
        try {
            OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(InetAddress.getLocalHost());
            int n2 = this.info.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                oncRpcPortmapClient.unsetPort(this.info[i2].program, this.info[i2].version);
            }
        }
        catch (IOException iOException) {
            throw new OncRpcException(16);
        }
    }

    public void unregister(String string) throws OncRpcException {
        try {
            OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(InetAddress.getByName(string));
            int n2 = this.info.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                oncRpcPortmapClient.unsetPort(this.info[i2].program, this.info[i2].version);
            }
        }
        catch (IOException iOException) {
            throw new OncRpcException(16);
        }
    }

    public abstract void close();

    public abstract void listen();

    public int getPort() {
        return this.port;
    }

    public abstract void setCharacterEncoding(String var1);

    public abstract String getCharacterEncoding();

    protected abstract void retrieveCall(XdrAble var1) throws OncRpcException, IOException;

    protected abstract XdrDecodingStream getXdrDecodingStream();

    protected abstract void endDecoding() throws OncRpcException, IOException;

    protected abstract XdrEncodingStream getXdrEncodingStream();

    protected abstract void beginEncoding(OncRpcCallInformation var1, OncRpcServerReplyMessage var2) throws OncRpcException, IOException;

    protected abstract void endEncoding() throws OncRpcException, IOException;

    protected abstract void reply(OncRpcCallInformation var1, OncRpcServerReplyMessage var2, XdrAble var3) throws OncRpcException, IOException;
}

