/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.acplt.oncrpc.ArRpcBindHelper;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcDumpResult;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcGetPortResult;
import org.acplt.oncrpc.OncRpcProgramNotRegisteredException;
import org.acplt.oncrpc.OncRpcServerIdent;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBoolean;
import org.acplt.oncrpc.XdrString;
import org.acplt.oncrpc.XdrVoid;

public class OncRpcPortmapClient {
    public static final int PMAP_PORT = 111;
    public static final int PMAP_PROGRAM = 100000;
    public static final int PMAP_VERSION = 2;
    protected OncRpcClient portmapClient;

    public OncRpcPortmapClient(InetAddress inetAddress) throws OncRpcException, IOException {
        this(inetAddress, 17, 0);
    }

    public OncRpcPortmapClient(InetAddress inetAddress, int n2) throws OncRpcException, IOException {
        this(inetAddress, n2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OncRpcPortmapClient(InetAddress inetAddress, int n2, int n3) throws OncRpcException, IOException {
        int n4 = 2;
        String string = "";
        if (inetAddress instanceof Inet6Address) {
            n4 = 4;
            string = "6";
        }
        int n5 = n4;
        int n6 = ArRpcBindHelper.getRpcBindTryStopVersion(n4);
        block4 : switch (n2) {
            case 17: {
                while (n5 >= n6) {
                    if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                        System.out.println("creating rpcbind udp" + string + " client v" + n5 + ", the fall back rpcbind will be ver:" + n6);
                    }
                    boolean bl = false;
                    try {
                        this.portmapClient = new OncRpcUdpClient(inetAddress, 100000, n5, 111);
                        bl = true;
                        if (!ArRpcBindHelper.rpcbind_client_debug.booleanValue()) continue;
                        System.out.println("created rpcbind udp" + string + " client v" + n5);
                    }
                    catch (OncRpcException oncRpcException) {
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind udp" + string + " client v" + n5 + " failed ");
                        }
                        if (n5 != n6) continue;
                        throw oncRpcException;
                    }
                    finally {
                        if (bl) break block4;
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind udp" + string + " client v" + n5 + " failed ");
                        }
                        --n5;
                    }
                }
                break;
            }
            case 6: {
                while (n5 >= n6) {
                    if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                        System.out.println("creating rpcbind tcp" + string + " client v" + n5 + ", the fall back rpcbind will be ver:" + n6);
                    }
                    boolean bl = false;
                    try {
                        this.portmapClient = new OncRpcTcpClient(inetAddress, 100000, n5, 111, 0, n3);
                        bl = true;
                        if (!ArRpcBindHelper.rpcbind_client_debug.booleanValue()) break block4;
                        System.out.println("created rpcbind tcp" + string + " client v" + n5);
                        break block4;
                    }
                    catch (OncRpcException oncRpcException) {
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind tcp" + string + " client v" + n5 + " failed ");
                        }
                        if (n5 != n6) continue;
                        throw oncRpcException;
                    }
                    finally {
                        if (bl) break block4;
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind tcp" + string + " client v" + n5 + " failed ");
                        }
                        --n5;
                    }
                }
                break;
            }
            default: {
                throw new OncRpcException(17);
            }
        }
    }

    public void close() throws OncRpcException {
        this.portmapClient.close();
    }

    public OncRpcClient getOncRpcClient() {
        return this.portmapClient;
    }

    public int getPort(int n2, int n3, int n4) throws OncRpcException {
        XdrAble xdrAble = ArRpcBindHelper.getRpcBindRequestParams(this.portmapClient.host, 3, n2, n3, n4, 0);
        XdrAble xdrAble2 = ArRpcBindHelper.getRpcBindResponseParams(this.portmapClient.host, 3, false);
        try {
            this.portmapClient.call(3, xdrAble, xdrAble2);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        int n5 = 0;
        if (this.portmapClient.host instanceof Inet6Address) {
            String string = ((XdrString)xdrAble2).stringValue();
            if (string != null && string.length() > 0) {
                n5 = ArRpcBindHelper.getPort(string);
            }
        } else {
            n5 = ((OncRpcGetPortResult)xdrAble2).port;
        }
        if (n5 == 0) {
            if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                System.out.println("rpcbind getPort did not get port back ");
            }
            throw new OncRpcProgramNotRegisteredException();
        }
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind getPort = " + n5);
        }
        return n5;
    }

    public boolean setPort(int n2, int n3, int n4, int n5) throws OncRpcException {
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind setPort ... " + n5);
        }
        XdrAble xdrAble = ArRpcBindHelper.getRpcBindRequestParams(this.portmapClient.host, 1, n2, n3, n4, n5);
        XdrAble xdrAble2 = ArRpcBindHelper.getRpcBindResponseParams(this.portmapClient.host, 1, false);
        try {
            this.portmapClient.call(1, xdrAble, xdrAble2);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind setPort returns boolean: " + ((XdrBoolean)xdrAble2).booleanValue());
        }
        return ((XdrBoolean)xdrAble2).booleanValue();
    }

    public boolean unsetPort(int n2, int n3) throws OncRpcException {
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind unsetPort ... ");
        }
        XdrAble xdrAble = ArRpcBindHelper.getRpcBindRequestParams(this.portmapClient.host, 2, n2, n3, 0, 0);
        XdrAble xdrAble2 = ArRpcBindHelper.getRpcBindResponseParams(this.portmapClient.host, 2, false);
        try {
            this.portmapClient.call(2, xdrAble, xdrAble2);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind unsetPort returns boolean: " + ((XdrBoolean)xdrAble2).booleanValue());
        }
        return ((XdrBoolean)xdrAble2).booleanValue();
    }

    public OncRpcServerIdent[] listServers() throws OncRpcException {
        OncRpcDumpResult oncRpcDumpResult = new OncRpcDumpResult();
        try {
            this.portmapClient.call(4, XdrVoid.XDR_VOID, oncRpcDumpResult);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        Object[] objectArray = new OncRpcServerIdent[oncRpcDumpResult.servers.size()];
        oncRpcDumpResult.servers.copyInto(objectArray);
        return objectArray;
    }

    public void ping() throws OncRpcException {
        try {
            this.portmapClient.call(0, XdrVoid.XDR_VOID, XdrVoid.XDR_VOID);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
    }
}

