/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.remoting.support;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class RemoteInvocation
implements Serializable {
    private static final long serialVersionUID = 6876024250231820554L;
    private String methodName;
    private Class[] parameterTypes;
    private Object[] arguments;
    private Map attributes;

    public RemoteInvocation() {
    }

    public RemoteInvocation(String methodName, Class[] parameterTypes, Object[] arguments) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.arguments = arguments;
    }

    public RemoteInvocation(MethodInvocation methodInvocation) {
        this.methodName = methodInvocation.getMethod().getName();
        this.parameterTypes = methodInvocation.getMethod().getParameterTypes();
        this.arguments = methodInvocation.getArguments();
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setParameterTypes(Class[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void addAttribute(String key, Serializable value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalStateException("Already an attribute with key '" + key + "' defined");
        }
        this.attributes.put(key, value);
    }

    public Serializable getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return (Serializable)this.attributes.get(key);
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Object invoke(Object targetObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = targetObject.getClass().getMethod(this.methodName, this.parameterTypes);
        return method.invoke(targetObject, this.arguments);
    }

    public String toString() {
        return this.getClass().getName() + ": methodName '" + this.methodName + "'; parameterTypes " + Arrays.asList(this.parameterTypes);
    }
}

