/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.jpa.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactoryAware;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactoryUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.ListableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.NoSuchBeanDefinitionException;
import com.bmc.thirdparty.org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import com.bmc.thirdparty.org.springframework.orm.jpa.EntityManagerFactoryInfo;
import com.bmc.thirdparty.org.springframework.orm.jpa.ExtendedEntityManagerCreator;
import com.bmc.thirdparty.org.springframework.orm.jpa.SharedEntityManagerCreator;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import com.bmc.thirdparty.org.springframework.util.ReflectionUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ListableBeanFactory beanFactory;
    private Map<Class<?>, List<AnnotatedMember>> classMetadata = new HashMap();

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalArgumentException("ListableBeanFactory required for EntityManagerFactory lookup");
        }
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    @Override
    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        List<AnnotatedMember> metadata = this.findClassMetadata(bean.getClass());
        for (AnnotatedMember member : metadata) {
            member.inject(bean);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AnnotatedMember> findClassMetadata(Class<? extends Object> clazz) {
        Map<Class<?>, List<AnnotatedMember>> map = this.classMetadata;
        synchronized (map) {
            List<AnnotatedMember> metadata = this.classMetadata.get(clazz);
            if (metadata == null) {
                final LinkedList<AnnotatedMember> newMetadata = new LinkedList<AnnotatedMember>();
                ReflectionUtils.doWithFields(clazz, new ReflectionUtils.FieldCallback(){

                    public void doWith(Field field) {
                        PersistenceAnnotationBeanPostProcessor.this.addIfPresent(newMetadata, field);
                    }
                });
                ReflectionUtils.doWithMethods(clazz, new ReflectionUtils.MethodCallback(){

                    public void doWith(Method method) {
                        PersistenceAnnotationBeanPostProcessor.this.addIfPresent(newMetadata, method);
                    }
                });
                metadata = newMetadata;
                this.classMetadata.put(clazz, metadata);
            }
            return metadata;
        }
    }

    private void addIfPresent(List<AnnotatedMember> metadata, AccessibleObject ao) {
        PersistenceContext pc = ao.getAnnotation(PersistenceContext.class);
        if (pc != null) {
            Properties properties = null;
            Object[] pps = pc.properties();
            if (!ObjectUtils.isEmpty(pps)) {
                properties = new Properties();
                for (int i2 = 0; i2 < pps.length; ++i2) {
                    Object pp = pps[i2];
                    properties.setProperty(pp.name(), pp.value());
                }
            }
            metadata.add(new AnnotatedMember(ao, pc.unitName(), pc.type(), properties));
        } else {
            PersistenceUnit pu = ao.getAnnotation(PersistenceUnit.class);
            if (pu != null) {
                metadata.add(new AnnotatedMember(ao, pu.unitName()));
            }
        }
    }

    protected EntityManagerFactory findEntityManagerFactory(String emfName) throws IllegalStateException {
        if (StringUtils.hasLength(emfName)) {
            return this.findNamedEntityManagerFactory(emfName);
        }
        return this.findDefaultEntityManagerFactory();
    }

    protected EntityManagerFactory findNamedEntityManagerFactory(String emfName) {
        String[] candidateNames;
        for (String candidateName : candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this.beanFactory, EntityManagerFactory.class)) {
            EntityManagerFactoryInfo emfi;
            EntityManagerFactory emf = (EntityManagerFactory)this.beanFactory.getBean(candidateName);
            String nameToCompare = candidateName;
            if (emf instanceof EntityManagerFactoryInfo && (emfi = (EntityManagerFactoryInfo)emf).getPersistenceUnitName() != null) {
                nameToCompare = emfi.getPersistenceUnitName();
            }
            if (!emfName.equals(nameToCompare)) continue;
            return emf;
        }
        throw new NoSuchBeanDefinitionException(EntityManagerFactory.class, "No EntityManagerFactory found for persistence unit name '" + emfName + "'");
    }

    protected EntityManagerFactory findDefaultEntityManagerFactory() {
        return (EntityManagerFactory)BeanFactoryUtils.beanOfTypeIncludingAncestors(this.beanFactory, EntityManagerFactory.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotatedMember {
        private final AccessibleObject member;
        private final String unitName;
        private final PersistenceContextType type;
        private final Properties properties;

        public AnnotatedMember(AccessibleObject member, String unitName) {
            this(member, unitName, null, null);
        }

        public AnnotatedMember(AccessibleObject member, String unitName, PersistenceContextType type, Properties properties) {
            this.unitName = unitName;
            this.type = type;
            this.properties = properties;
            this.member = member;
            Class<?> memberType = this.getMemberType();
            if (!EntityManagerFactory.class.isAssignableFrom(memberType) && !EntityManager.class.isAssignableFrom(memberType)) {
                throw new IllegalArgumentException("Cannot inject " + member + ": not a supported JPA type");
            }
        }

        public void inject(Object instance) {
            block6: {
                Object value = this.resolve();
                try {
                    if (!this.member.isAccessible()) {
                        this.member.setAccessible(true);
                    }
                    if (this.member instanceof Field) {
                        ((Field)this.member).set(instance, value);
                        break block6;
                    }
                    if (this.member instanceof Method) {
                        ((Method)this.member).invoke(instance, value);
                        break block6;
                    }
                    throw new IllegalArgumentException("Cannot inject unknown AccessibleObject type " + this.member);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException("Cannot inject member " + this.member, ex);
                }
                catch (InvocationTargetException ex) {
                    throw new IllegalArgumentException("Attempt to inject setter method " + this.member + " resulted in an exception", ex);
                }
            }
        }

        public Class<?> getMemberType() {
            if (this.member instanceof Field) {
                return ((Field)this.member).getType();
            }
            if (this.member instanceof Method) {
                Method setter = (Method)this.member;
                if (setter.getParameterTypes().length != 1) {
                    throw new IllegalArgumentException("Supposed setter [" + this.member + "] must have 1 argument, not " + setter.getParameterTypes().length);
                }
                return setter.getParameterTypes()[0];
            }
            throw new IllegalArgumentException("Unknown AccessibleObject type [" + this.member.getClass() + "]; can only inject setter methods and fields");
        }

        protected Object resolve() {
            EntityManagerFactory emf = PersistenceAnnotationBeanPostProcessor.this.findEntityManagerFactory(this.unitName);
            if (EntityManagerFactory.class.isAssignableFrom(this.getMemberType())) {
                if (!this.getMemberType().isInstance(emf)) {
                    throw new IllegalArgumentException("Cannot inject [" + this.member + "] with EntityManagerFactory [" + emf + "]: type mismatch");
                }
                return emf;
            }
            if (this.type == PersistenceContextType.TRANSACTION) {
                return SharedEntityManagerCreator.createSharedEntityManager(emf, this.properties, this.getMemberType());
            }
            return ExtendedEntityManagerCreator.createContainerManagedEntityManager(emf, this.properties);
        }
    }
}

