/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.jpa;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.orm.jpa.EntityManagerFactoryUtils;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.CollectionUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

public abstract class EntityManagerFactoryAccessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private EntityManagerFactory entityManagerFactory;
    private final Map jpaPropertyMap = new HashMap();

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setJpaProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap(jpaProperties, this.jpaPropertyMap);
    }

    public void setJpaPropertyMap(Map jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }

    public Map getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    protected EntityManager createEntityManager() throws IllegalStateException {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        Assert.state(emf != null, "No EntityManagerFactory specified");
        Map properties = this.getJpaPropertyMap();
        return !CollectionUtils.isEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
    }

    protected EntityManager getTransactionalEntityManager() throws IllegalStateException {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        Assert.state(emf != null, "No EntityManagerFactory specified");
        return EntityManagerFactoryUtils.getTransactionalEntityManager(emf, this.getJpaPropertyMap());
    }
}

