/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignFilterApiInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.ProcessResult;
import com.bmc.arsys.api.Util;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;

public class AssignInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -811819494407985607L;
    private int m_assignType;
    private Value m_value;
    private AssignFieldInfo m_field;
    private String m_process;
    private ArithOpAssignInfo m_arithOp;
    private FunctionAssignInfo m_function;
    private DDEAction m_dde;
    private AssignSQLInfo m_sql;
    private AssignFilterApiInfo m_filterApi;
    private String assignmentAsString;
    public static final int AR_ASSIGN_TYPE_NONE = 0;
    public static final int AR_ASSIGN_TYPE_VALUE = 1;
    public static final int AR_ASSIGN_TYPE_FIELD = 2;
    public static final int AR_ASSIGN_TYPE_PROCESS = 3;
    public static final int AR_ASSIGN_TYPE_ARITH = 4;
    public static final int AR_ASSIGN_TYPE_FUNCTION = 5;
    public static final int AR_ASSIGN_TYPE_DDE = 6;
    public static final int AR_ASSIGN_TYPE_SQL = 7;
    public static final int AR_ASSIGN_TYPE_FILTER_API = 8;

    public Value getValue() {
        return this.m_value;
    }

    public void setValue(Value value) {
        this.m_value = value;
    }

    public AssignFieldInfo getField() {
        return this.m_field;
    }

    public void setField(AssignFieldInfo assignFieldInfo) {
        this.m_field = assignFieldInfo;
    }

    public String getProcess() {
        return this.m_process;
    }

    public void setProcess(String string) {
        this.m_process = string;
    }

    public ArithOpAssignInfo getArithOp() {
        return this.m_arithOp;
    }

    public void setArithOp(ArithOpAssignInfo arithOpAssignInfo) {
        this.m_arithOp = arithOpAssignInfo;
    }

    public FunctionAssignInfo getFunction() {
        return this.m_function;
    }

    public void setFunction(FunctionAssignInfo functionAssignInfo) {
        this.m_function = functionAssignInfo;
    }

    public DDEAction getDde() {
        return this.m_dde;
    }

    public void setDde(DDEAction dDEAction) {
        this.m_dde = dDEAction;
    }

    public AssignSQLInfo getSql() {
        return this.m_sql;
    }

    public void setSql(AssignSQLInfo assignSQLInfo) {
        this.m_sql = assignSQLInfo;
    }

    public AssignFilterApiInfo getFilterApi() {
        return this.m_filterApi;
    }

    public void setFilterApi(AssignFilterApiInfo assignFilterApiInfo) {
        this.m_filterApi = assignFilterApiInfo;
    }

    public AssignInfo() {
    }

    public AssignInfo(DDEAction dDEAction) {
        this.setAssignType(6);
        try {
            this.m_dde = (DDEAction)dDEAction.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public int getAssignType() {
        return this.m_assignType;
    }

    public void setAssignType(int n2) {
        this.m_assignType = n2;
    }

    public Object clone() throws CloneNotSupportedException {
        AssignInfo assignInfo = (AssignInfo)super.clone();
        assignInfo.m_value = null;
        assignInfo.m_field = null;
        assignInfo.m_process = null;
        assignInfo.m_arithOp = null;
        assignInfo.m_function = null;
        assignInfo.m_dde = null;
        assignInfo.m_sql = null;
        assignInfo.m_filterApi = null;
        switch (this.m_assignType) {
            case 0: {
                break;
            }
            case 1: {
                if (this.m_value == null) break;
                assignInfo.m_value = (Value)this.m_value.clone();
                break;
            }
            case 2: {
                if (this.m_field == null) break;
                assignInfo.m_field = (AssignFieldInfo)this.m_field.clone();
                break;
            }
            case 3: {
                assignInfo.m_process = this.m_process;
                break;
            }
            case 4: {
                if (this.m_arithOp == null) break;
                assignInfo.m_arithOp = (ArithOpAssignInfo)this.m_arithOp.clone();
                break;
            }
            case 5: {
                if (this.m_function == null) break;
                assignInfo.m_function = (FunctionAssignInfo)this.m_function.clone();
                break;
            }
            case 6: {
                if (this.m_dde == null) break;
                assignInfo.m_dde = (DDEAction)this.m_dde.clone();
                break;
            }
            case 7: {
                if (this.m_sql == null) break;
                assignInfo.m_sql = (AssignSQLInfo)this.m_sql.clone();
                break;
            }
            case 8: {
                if (this.m_filterApi == null) break;
                assignInfo.m_filterApi = (AssignFilterApiInfo)this.m_filterApi.clone();
                break;
            }
        }
        return assignInfo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AssignInfo)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        AssignInfo assignInfo = (AssignInfo)object;
        return new EqualsBuilder().append(this.m_assignType, assignInfo.m_assignType).append(this.m_value, assignInfo.m_value).append(this.m_field, assignInfo.m_field).append(this.m_process, assignInfo.m_process).append(this.m_arithOp, assignInfo.m_arithOp).append(this.m_function, assignInfo.m_function).append(this.m_dde, assignInfo.m_dde).append(this.m_sql, assignInfo.m_sql).append(this.m_filterApi, assignInfo.m_filterApi).isEquals();
    }

    public boolean equals(Object object, String string, String string2, String string3, String string4) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AssignInfo)) {
            return false;
        }
        AssignInfo assignInfo = (AssignInfo)object;
        return this.m_assignType == assignInfo.m_assignType && (this.m_value == null ? assignInfo.m_value == null : this.m_value.equals(assignInfo.m_value)) && (this.m_field == null ? assignInfo.m_field == null : this.m_field.equals(assignInfo.m_field, string, string2, string3, string4)) && (this.m_process == null ? assignInfo.m_process == null : this.m_process.equals(assignInfo.m_process)) && (this.m_arithOp == null ? assignInfo.m_arithOp == null : this.m_arithOp.equals(assignInfo.m_arithOp, string, string2, string3, string4)) && (this.m_function == null ? assignInfo.m_function == null : this.m_function.equals(assignInfo.m_function)) && (this.m_dde == null ? assignInfo.m_dde == null : this.m_dde.equals(assignInfo.m_dde)) && (this.m_sql == null ? assignInfo.m_sql == null : this.m_sql.equals(assignInfo.m_sql)) && (this.m_filterApi == null ? assignInfo.m_filterApi == null : this.m_filterApi.equals(assignInfo.m_filterApi));
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_assignType).append(this.m_value).append(this.m_field).append(this.m_process).append(this.m_arithOp).append(this.m_function).append(this.m_dde).append(this.m_sql).append(this.m_filterApi).toHashCode();
    }

    void fromVariant(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return;
        }
        int n2 = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)objectArray, 0));
        this.setAssignType(n2);
        Object object = ARTypeMgr.GetAt((Object)objectArray, 1);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                this.m_value = ARTypeMgr.getInstance().ObjectFromVariant(Value.class, object, aRServerUser);
                break;
            }
            case 2: {
                this.m_field = ARTypeMgr.getInstance().ObjectFromVariant(AssignFieldInfo.class, object, aRServerUser);
                break;
            }
            case 3: {
                this.m_process = (String)object;
                break;
            }
            case 4: {
                this.m_arithOp = ARTypeMgr.getInstance().ObjectFromVariant(ArithOpAssignInfo.class, object, aRServerUser);
                break;
            }
            case 5: {
                this.m_function = ARTypeMgr.getInstance().ObjectFromVariant(FunctionAssignInfo.class, object, aRServerUser);
                break;
            }
            case 6: {
                this.m_dde = ARTypeMgr.getInstance().ObjectFromVariant(DDEAction.class, object, aRServerUser);
                break;
            }
            case 7: {
                this.m_sql = ARTypeMgr.getInstance().ObjectFromVariant(AssignSQLInfo.class, object, aRServerUser);
                break;
            }
            case 8: {
                this.m_filterApi = ARTypeMgr.getInstance().ObjectFromVariant(AssignFilterApiInfo.class, object, aRServerUser);
                break;
            }
            default: {
                throw new IllegalArgumentException("assigntype not supported by this method");
            }
        }
    }

    static AssignInfo createInstance(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return null;
        }
        AssignInfo assignInfo = new AssignInfo();
        if (objectArray.length == 2 && objectArray[0] != null) {
            assignInfo.fromVariant(objectArray, aRServerUser);
        }
        return assignInfo;
    }

    Object toVariant(ARServerUser aRServerUser) {
        Object[] objectArray = new Object[2];
        int n2 = this.getAssignType();
        objectArray[0] = new Integer(n2);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_value, aRServerUser);
                break;
            }
            case 2: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_field, aRServerUser);
                break;
            }
            case 3: {
                objectArray[1] = this.m_process;
                break;
            }
            case 4: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_arithOp, aRServerUser);
                break;
            }
            case 5: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_function, aRServerUser);
                break;
            }
            case 6: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_dde, aRServerUser);
                break;
            }
            case 7: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_sql, aRServerUser);
                break;
            }
            case 8: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_filterApi, aRServerUser);
                break;
            }
            default: {
                throw new IllegalArgumentException("assigntype not supported by this method");
            }
        }
        return objectArray;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Assign Type", this.m_assignType).append("Value", this.m_value).append("Field", this.m_field).append("Process", this.m_process).append("Arith Op", this.m_arithOp).append("Function", this.m_function).append("Dde", this.m_dde).append("Sql", this.m_sql).append("Filter Api", this.m_filterApi).toString();
    }

    void prepareAssignmentString(ARServerUser aRServerUser, String string, int n2, String string2) throws ARException {
        String string3 = "";
        int n3 = this.getAssignType();
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                string3 = this.getValue().toString();
                break;
            }
            case 3: {
                string3 = String.format("$PROCESS$ %s", this.getProcess());
                break;
            }
            case 6: {
                DDEAction dDEAction = this.getDde();
                String string4 = dDEAction.getServiceName();
                String string5 = dDEAction.getTopic();
                String string6 = dDEAction.getItem();
                String string7 = dDEAction.getPathToProgram();
                string3 = String.format("$DDE$ %s;%s;%s%s%s", string4, string5, string7, string6.length() > 0 ? ";" : "", string6);
                break;
            }
            case 8: {
                string3 = "$" + Long.toString(this.getFilterApi().getValueIndex()) + "$";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string3 = aRServerUser.encodeAssignment(this);
                string3 = aRServerUser.formatAssignment(string, n2, string2, string3);
                if (!Util.isFieldIdPresent(string3) || string2 == null || string2.length() <= 0) break;
                try {
                    ProcessResult processResult = aRServerUser.executeSpecialCommand("Application-Map-Ids-To-Names", string2, string3);
                    string3 = processResult.getOutput();
                }
                catch (ARException aRException) {}
                break;
            }
            case 7: {
                string3 = "$" + Long.toString(this.getSql().getValueIndex()) + "$";
            }
        }
        if (string3 == null) {
            string3 = new Value(Keyword.AR_KEYWORD_NO).toString();
        }
        this.setAssignmentAsString(string3);
    }

    public String getAssignmentAsString() {
        return this.assignmentAsString;
    }

    public void setAssignmentAsString(String string) {
        this.assignmentAsString = string;
    }
}

