/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcServerAuth;

public final class OncRpcServerAuthUnix
extends OncRpcServerAuth {
    public int stamp;
    public String machinename;
    public int uid;
    public int gid;
    public int[] gids;
    private byte[] shorthandVerf;

    public OncRpcServerAuthUnix(XdrDecodingStream xdrDecodingStream) throws OncRpcException, IOException {
        this.xdrDecodeCredVerf(xdrDecodingStream);
    }

    @Override
    public final int getAuthenticationType() {
        return 1;
    }

    public final void setShorthandVerifier(byte[] byArray) {
        this.shorthandVerf = byArray;
    }

    public final byte[] getShorthandVerifier() {
        return this.shorthandVerf;
    }

    @Override
    public final void xdrDecodeCredVerf(XdrDecodingStream xdrDecodingStream) throws OncRpcException, IOException {
        this.shorthandVerf = null;
        int n = xdrDecodingStream.xdrDecodeInt();
        this.stamp = xdrDecodingStream.xdrDecodeInt();
        this.machinename = xdrDecodingStream.xdrDecodeString();
        this.uid = xdrDecodingStream.xdrDecodeInt();
        this.gid = xdrDecodingStream.xdrDecodeInt();
        this.gids = xdrDecodingStream.xdrDecodeIntVector();
        int n2 = 4 + (this.machinename.length() + 7 & 0xFFFFFFFC) + 4 + 4 + this.gids.length * 4 + 4;
        if (n != n2) {
            if (n < n2) {
                throw new OncRpcException(43);
            }
            throw new OncRpcException(7);
        }
        if (xdrDecodingStream.xdrDecodeInt() != 0 || xdrDecodingStream.xdrDecodeInt() != 0) {
            throw new OncRpcAuthenticationException(3);
        }
    }

    @Override
    public final void xdrEncodeVerf(XdrEncodingStream xdrEncodingStream) throws OncRpcException, IOException {
        if (this.shorthandVerf != null) {
            xdrEncodingStream.xdrEncodeInt(2);
            xdrEncodingStream.xdrEncodeDynamicOpaque(this.shorthandVerf);
        } else {
            xdrEncodingStream.xdrEncodeInt(0);
            xdrEncodingStream.xdrEncodeInt(0);
        }
    }
}

