/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.toplink;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.orm.toplink.ServerSessionFactory;
import com.bmc.thirdparty.org.springframework.orm.toplink.SessionBrokerSessionFactory;
import com.bmc.thirdparty.org.springframework.orm.toplink.SessionFactory;
import com.bmc.thirdparty.org.springframework.orm.toplink.SingleSessionFactory;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.jndi.JNDIConnector;
import oracle.toplink.sessionbroker.SessionBroker;
import oracle.toplink.sessions.Connector;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.SessionLog;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.sessionconfiguration.XMLLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;

public class LocalSessionFactory {
    public static final String DEFAULT_SESSIONS_XML = "sessions.xml";
    public static final String DEFAULT_SESSION_NAME = "Session";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String configLocation = "sessions.xml";
    private String sessionName = "Session";
    private ClassLoader sessionClassLoader;
    private DatabaseLogin databaseLogin;
    private DataSource dataSource;
    private DatabasePlatform databasePlatform;
    private SessionLog sessionLog;
    static /* synthetic */ Class class$oracle$toplink$sessions$DatabaseSession;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$oracle$toplink$tools$sessionmanagement$SessionManager;

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setSessionClassLoader(ClassLoader sessionClassLoader) {
        this.sessionClassLoader = sessionClassLoader;
    }

    public void setDatabaseLogin(DatabaseLogin databaseLogin) {
        this.databaseLogin = databaseLogin;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public void setSessionLog(SessionLog sessionLog) {
        this.sessionLog = sessionLog;
    }

    public SessionFactory createSessionFactory() throws TopLinkException {
        ClassLoader classLoader;
        DatabaseSession session;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initializing TopLink SessionFactory from [" + this.configLocation + "]");
        }
        if ((session = this.loadDatabaseSession(this.configLocation, this.sessionName, classLoader = this.sessionClassLoader != null ? this.sessionClassLoader : ClassUtils.getDefaultClassLoader())) == null) {
            throw new IllegalStateException("A session named " + this.sessionName + " could not be loaded from resource [" + this.configLocation + "] using ClassLoader [" + classLoader + "]. " + "This is most likely a deployment issue: Can the class loader access the resource?");
        }
        if (this.databaseLogin != null) {
            this.reflectivelySetDatabaseLogin(session, this.databaseLogin);
        }
        if (this.dataSource != null) {
            session.getLogin().setConnector((Connector)new JNDIConnector(this.dataSource));
            session.getLogin().setUsesExternalConnectionPooling(true);
        }
        if (this.databasePlatform != null) {
            session.getLogin().usePlatform(this.databasePlatform);
        }
        if (this.sessionLog != null) {
            session.setSessionLog(this.sessionLog);
            session.logMessages();
        }
        session.login();
        return this.newSessionFactory(session);
    }

    protected void reflectivelySetDatabaseLogin(DatabaseSession session, DatabaseLogin login) {
        Method setLoginMethod = null;
        try {
            Class<?> loginClass = Class.forName("oracle.toplink.sessions.Login");
            setLoginMethod = (class$oracle$toplink$sessions$DatabaseSession == null ? (class$oracle$toplink$sessions$DatabaseSession = LocalSessionFactory.class$("oracle.toplink.sessions.DatabaseSession")) : class$oracle$toplink$sessions$DatabaseSession).getMethod("setLogin", loginClass);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using TopLink 10.1.3 setLogin(Login) API");
            }
        }
        catch (Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using TopLink 9.0.4 setLogin(DatabaseLogin) API");
            }
            session.setLogin(login);
            return;
        }
        try {
            setLoginMethod.invoke((Object)session, login);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    protected DatabaseSession loadDatabaseSession(String configLocation, String sessionName, ClassLoader sessionClassLoader) throws TopLinkException {
        SessionManager manager = this.getSessionManager();
        Class<?> loaderClass = null;
        Method getSessionMethod = null;
        try {
            loaderClass = Class.forName("oracle.toplink.tools.sessionconfiguration.XMLSessionConfigLoader");
            getSessionMethod = (class$oracle$toplink$tools$sessionmanagement$SessionManager == null ? (class$oracle$toplink$tools$sessionmanagement$SessionManager = LocalSessionFactory.class$("oracle.toplink.tools.sessionmanagement.SessionManager")) : class$oracle$toplink$tools$sessionmanagement$SessionManager).getMethod("getSession", loaderClass, class$java$lang$String == null ? (class$java$lang$String = LocalSessionFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = LocalSessionFactory.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using TopLink 10.1.3 XMLSessionConfigLoader");
            }
        }
        catch (Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using TopLink 9.0.4 XMLLoader");
            }
            XMLLoader loader = new XMLLoader(configLocation);
            return (DatabaseSession)manager.getSession(loader, sessionName, sessionClassLoader, false, false);
        }
        try {
            Constructor<?> ctor = loaderClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = LocalSessionFactory.class$("java.lang.String")) : class$java$lang$String);
            Object loader = ctor.newInstance(configLocation);
            return (DatabaseSession)getSessionMethod.invoke((Object)manager, loader, sessionName, sessionClassLoader, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    protected SessionManager getSessionManager() {
        return new SessionManager();
    }

    protected SessionFactory newSessionFactory(DatabaseSession session) {
        if (session instanceof ServerSession) {
            return new ServerSessionFactory((ServerSession)session);
        }
        if (session instanceof SessionBroker) {
            return new SessionBrokerSessionFactory((SessionBroker)session);
        }
        return new SingleSessionFactory((Session)session);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

