/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.util;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Loader {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$util$Loader == null ? (class$org$apache$ws$security$util$Loader = Loader.class$("org.apache.ws.security.util.Loader")) : class$org$apache$ws$security$util$Loader).getName());
    static /* synthetic */ Class class$org$apache$ws$security$util$Loader;

    public static URL getResource(String resource) {
        ClassLoader classLoader = null;
        URL url = null;
        try {
            classLoader = Loader.getTCL();
            if (classLoader != null) {
                log.debug((Object)("Trying to find [" + resource + "] using " + classLoader + " class loader."));
                url = classLoader.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Caught Exception while in Loader.getResource. This may be innocuous.", t);
        }
        log.debug((Object)("Trying to find [" + resource + "] using ClassLoader.getSystemResource()."));
        return ClassLoader.getSystemResource(resource);
    }

    public static URL getResource(ClassLoader loader, String resource) {
        URL url = null;
        try {
            if (loader != null) {
                log.debug((Object)("Trying to find [" + resource + "] using " + loader + " class loader."));
                url = loader.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Caught Exception while in Loader.getResource. This may be innocuous.", t);
        }
        return Loader.getResource(resource);
    }

    public static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static ClassLoader getClassLoader(final Class clazz) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }

    public static Class loadClass(ClassLoader loader, String clazz) throws ClassNotFoundException {
        try {
            Class<?> c;
            if (loader != null && (c = loader.loadClass(clazz)) != null) {
                return c;
            }
        }
        catch (Throwable e) {
            log.warn((Object)e.getMessage(), e);
        }
        return Loader.loadClass(clazz, true);
    }

    public static Class loadClass(String clazz) throws ClassNotFoundException {
        return Loader.loadClass(clazz, true);
    }

    public static Class loadClass(String clazz, boolean warn) throws ClassNotFoundException {
        try {
            Class<?> c;
            ClassLoader tcl = Loader.getTCL();
            if (tcl != null && (c = tcl.loadClass(clazz)) != null) {
                return c;
            }
        }
        catch (Throwable e) {
            if (warn) {
                log.warn((Object)e.getMessage(), e);
            }
            log.debug((Object)e.getMessage(), e);
        }
        return Class.forName(clazz);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

