/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet;

import com.bmc.thirdparty.org.springframework.util.AntPathMatcher;
import com.bmc.thirdparty.org.springframework.util.PathMatcher;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.web.context.support.ServletContextResource;
import com.bmc.thirdparty.org.springframework.web.servlet.HttpServletBean;
import java.io.File;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceServlet
extends HttpServletBean {
    public static final String RESOURCE_URL_DELIMITERS = ",; \t\n";
    public static final String RESOURCE_PARAM_NAME = "resource";
    private String defaultUrl;
    private String allowedResources;
    private String contentType;
    private boolean applyLastModified = false;
    private PathMatcher pathMatcher;
    private long startupTime;

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public void setAllowedResources(String allowedResources) {
        this.allowedResources = allowedResources;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setApplyLastModified(boolean applyLastModified) {
        this.applyLastModified = applyLastModified;
    }

    protected void initServletBean() {
        this.pathMatcher = this.getPathMatcher();
        this.startupTime = System.currentTimeMillis();
    }

    protected PathMatcher getPathMatcher() {
        return new AntPathMatcher();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourceUrl = this.determineResourceUrl(request);
        if (resourceUrl != null) {
            try {
                this.doInclude(request, response, resourceUrl);
                return;
            }
            catch (ServletException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Failed to include content of resource [" + resourceUrl + "]", ex);
                }
                if (this.includeDefaultUrl(request, response)) return;
                throw ex;
            }
            catch (IOException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Failed to include content of resource [" + resourceUrl + "]", ex);
                }
                if (this.includeDefaultUrl(request, response)) return;
                throw ex;
            }
        } else {
            if (this.includeDefaultUrl(request, response)) return;
            throw new ServletException("No target resource URL found for request");
        }
    }

    protected String determineResourceUrl(HttpServletRequest request) {
        return request.getParameter(RESOURCE_PARAM_NAME);
    }

    private boolean includeDefaultUrl(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.defaultUrl == null) {
            return false;
        }
        this.doInclude(request, response, this.defaultUrl);
        return true;
    }

    private void doInclude(HttpServletRequest request, HttpServletResponse response, String resourceUrl) throws ServletException, IOException {
        if (this.contentType != null) {
            response.setContentType(this.contentType);
        }
        String[] resourceUrls = StringUtils.tokenizeToStringArray(resourceUrl, RESOURCE_URL_DELIMITERS);
        for (int i2 = 0; i2 < resourceUrls.length; ++i2) {
            if (this.allowedResources != null && !this.pathMatcher.match(this.allowedResources, resourceUrls[i2])) {
                throw new ServletException("Resource [" + resourceUrls[i2] + "] does not match allowed pattern [" + this.allowedResources + "]");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Including resource [" + resourceUrls[i2] + "]");
            }
            RequestDispatcher rd = request.getRequestDispatcher(resourceUrls[i2]);
            rd.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected final long getLastModified(HttpServletRequest request) {
        if (this.applyLastModified) {
            String resourceUrl = this.determineResourceUrl(request);
            if (resourceUrl == null) {
                resourceUrl = this.defaultUrl;
            }
            if (resourceUrl != null) {
                String[] resourceUrls = StringUtils.tokenizeToStringArray(resourceUrl, RESOURCE_URL_DELIMITERS);
                long latestTimestamp = -1L;
                for (int i2 = 0; i2 < resourceUrls.length; ++i2) {
                    long timestamp = this.getFileTimestamp(resourceUrls[i2]);
                    if (timestamp <= latestTimestamp) continue;
                    latestTimestamp = timestamp;
                }
                return latestTimestamp > this.startupTime ? latestTimestamp : this.startupTime;
            }
        }
        return -1L;
    }

    protected long getFileTimestamp(String resourceUrl) {
        try {
            File resource = new ServletContextResource(this.getServletContext(), resourceUrl).getFile();
            long lastModifiedTime = resource.lastModified();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Last-modified timestamp of resource file [" + resource.getAbsolutePath() + "] is [" + lastModifiedTime + "]");
            }
            return lastModifiedTime;
        }
        catch (IOException ex) {
            this.logger.warn("Couldn't retrieve lastModified timestamp of resource [" + resourceUrl + "] - returning ResourceServlet startup time");
            return -1L;
        }
    }
}

