/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.transaction.jta;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.FactoryBean;
import com.bmc.thirdparty.org.springframework.transaction.TransactionSystemException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.TransactionManager;

public class WebLogicServerTransactionManagerFactoryBean
implements FactoryBean {
    private static final String TX_HELPER_CLASS_NAME = "weblogic.transaction.TxHelper";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final TransactionManager transactionManager;

    public WebLogicServerTransactionManagerFactoryBean() throws TransactionSystemException {
        try {
            this.logger.debug("Looking for WebLogic TxHelper: weblogic.transaction.TxHelper");
            Class<?> helperClass = Class.forName(TX_HELPER_CLASS_NAME);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found WebLogic TxHelper: " + helperClass.getName());
            }
            Method method = helperClass.getMethod("getTransactionManager", null);
            this.transactionManager = (TransactionManager)method.invoke(null, (Object[])null);
        }
        catch (ClassNotFoundException ex) {
            throw new TransactionSystemException("Could not find WebLogic's TxHelper class", ex);
        }
        catch (InvocationTargetException ex) {
            throw new TransactionSystemException("WebLogic's TxHelper.getTransactionManager method failed", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not access WebLogic's TxHelper.getTransactionManager method", ex);
        }
    }

    public Object getObject() {
        return this.transactionManager;
    }

    public Class getObjectType() {
        return this.transactionManager.getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

