/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldCriteria;
import com.bmc.arsys.api.FieldKey;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.IndexInfo;
import com.bmc.arsys.api.SQLResult;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.demo.javadriver.InputReader;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.OutputWriter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class OracleFunctionalIndexHelper
extends JavaDriver {
    static OutputWriter outputWriter = new OutputWriter();
    ARServerUser arServerUser;
    ArrayList<String> schemaNames;
    ArrayList<String> functionalIndexes;
    ArrayList<String> regularIndexes;
    private static final int COMMAND_OPTION_ADD_INDEX = 0;
    private static final int COMMAND_OPTION_DROP_INDEX = 1;
    private static final int COMMAND_OPTION_VIEW_INDEX = 2;
    private static final int COMMAND_OPTION_QUIT_APP = 3;
    private static final int COMMAND_OPTION_MAX_USED = 3;
    private static final int COMMAND_OPTION_REGULAR_INDEX = 0;
    private static final int COMMAND_OPTION_FUNCTIONAL_INDEX = 1;

    public OracleFunctionalIndexHelper() {
        this.initThreadControlBlockPtr();
        this.schemaNames = new ArrayList();
        this.functionalIndexes = new ArrayList();
        this.regularIndexes = new ArrayList();
    }

    public int getSchemaCount() {
        return this.schemaNames.size();
    }

    void readSchemaNames(String string) throws ARException, FileNotFoundException, IOException {
        if (string == null || string.length() == 0) {
            this.schemaNames = (ArrayList)this.arServerUser.getListForm(0L);
        } else {
            this.populateSchemaNamesFromFile(string);
        }
    }

    private int getSchemaIdForSchema(String string) throws ARException {
        FormCriteria formCriteria = new FormCriteria();
        formCriteria.setPropertiesToRetrieve(FormCriteria.SCHEMA_TYPE);
        Form form = this.arServerUser.getForm(string, formCriteria);
        if (form == null) {
            new ARException(2, 303, string);
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("SELECT schemaId from arschema where name='" + string + "'");
        SQLResult sQLResult = this.arServerUser.getListSQL(stringBuilder.toString(), 1, false);
        if (sQLResult == null) {
            throw new ARException(2, 303, string);
        }
        List<List<Value>> list = sQLResult.getContents();
        if (list == null || list.size() == 0) {
            throw new ARException(2, 303, string);
        }
        n = list.get(0).get(0).getIntValue();
        if (n == 0) {
            throw new ARException(2, 303, string);
        }
        return n;
    }

    private void populateSchemaNamesFromFile(String string) throws FileNotFoundException, IOException {
        JavaDriver.getThreadControlBlockPtr().setCurrentInputFile(string);
        String string2 = null;
        BufferedReader bufferedReader = JavaDriver.getThreadControlBlockPtr().getCurrentInputFile();
        string2 = bufferedReader.readLine();
        while (string2 != null) {
            int n = 0;
            for (n = string2.length() - 1; n >= 0 && string2.charAt(n) == ' ' && string2.charAt(n) == '\t' && string2.charAt(n) == '\n'; --n) {
            }
            if (string2.length() >= 1 && string2.charAt(0) == '#') continue;
            this.schemaNames.add(string2);
            string2 = bufferedReader.readLine();
        }
        JavaDriver.getThreadControlBlockPtr().closeCurrentInputFile();
    }

    void createDBIndexes(String string) {
        String string2 = null;
        for (int i = 0; i < this.schemaNames.size(); ++i) {
            string2 = this.schemaNames.get(i);
            if (string2 == null) continue;
            outputWriter.printHeader("", "Currently processing Form " + string2 + "...", "\n");
            try {
                this.createDBIndexesForSchema(string2, string);
                continue;
            }
            catch (ARException aRException) {
                outputWriter.printHeader("", "Error while processing schema " + string2 + ".", "\n");
                outputWriter.printHeader("", "Error message " + aRException.getMessage() + ".", "\n");
            }
        }
    }

    void dropDBIndexes(boolean bl) {
        String string = null;
        for (int i = 0; i < this.schemaNames.size(); ++i) {
            string = this.schemaNames.get(i);
            if (string == null) continue;
            outputWriter.printHeader("", "Currently processing Form " + string + "...", "\n");
            try {
                this.dropDBIndexesForSchema(string, bl);
                continue;
            }
            catch (ARException aRException) {
                outputWriter.printHeader("", "Error while processing schema " + string + ".", "\n");
                outputWriter.printHeader("", "Error message " + aRException.getMessage() + ".", "\n");
            }
        }
    }

    void viewDBIndexes() {
        String string = null;
        for (int i = 0; i < this.schemaNames.size(); ++i) {
            string = this.schemaNames.get(i);
            if (string == null) continue;
            outputWriter.printHeader("\n", "Currently processing Form " + string + "...", "\n");
            try {
                this.viewDBIndexesForSchema(string);
                continue;
            }
            catch (ARException aRException) {
                outputWriter.printHeader("", "Error while processing schema " + string + ".", "\n");
                outputWriter.printHeader("", "Error message " + aRException.getMessage() + ".", "\n");
            }
        }
    }

    void viewDBIndexesForSchema(String string) throws ARException {
        int n;
        int n2 = this.getSchemaIdForSchema(string);
        if (n2 == 0) {
            outputWriter.printHeader("", "Error while retrieving schema id for schema " + string + ".", "\n");
            return;
        }
        this.retrieveExistingIndexes(n2);
        outputWriter.printHeader("\n", string + " has " + this.regularIndexes.size() + " regular and " + this.functionalIndexes.size() + " functional indexes.", "\n");
        for (n = 1; n <= this.regularIndexes.size(); ++n) {
            outputWriter.printHeader("\n\t", " Regular Index# " + n + ": ", this.regularIndexes.get(n - 1));
        }
        for (n = 1; n <= this.functionalIndexes.size(); ++n) {
            outputWriter.printHeader("\n\t", " Functional Index# " + n + ": ", this.functionalIndexes.get(n - 1));
        }
    }

    private void retrieveExistingIndexes(int n) {
        this.regularIndexes.clear();
        this.functionalIndexes.clear();
        StringBuilder stringBuilder = new StringBuilder("SELECT index_name, index_type from all_indexes where table_name = 'T" + n + "'");
        try {
            SQLResult sQLResult = this.arServerUser.getListSQL(stringBuilder.toString(), 100, false);
            List<List<Value>> list = sQLResult.getContents();
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).get(1).toString().contains("FUNCTION-BASED")) {
                    this.functionalIndexes.add(list.get(i).get(0).toString());
                    continue;
                }
                this.regularIndexes.add(list.get(i).get(0).toString());
            }
        }
        catch (ARException aRException) {
            // empty catch block
        }
    }

    boolean isExistingIndex(String string, String string2) {
        return string2 != null ? this.functionalIndexes.contains(string) || this.functionalIndexes.contains(string + "_CI") : this.regularIndexes.contains(string) || this.regularIndexes.contains(string + "_CS");
    }

    private void createCurrentDBIndex(String string, int n, IndexInfo indexInfo, String string2) throws ARException {
        StringBuffer stringBuffer = new StringBuffer(indexInfo.getIndexName());
        if (this.isExistingIndex(stringBuffer.toString(), string2)) {
            outputWriter.printHeader("", " Index " + stringBuffer + " already exists.", "\n");
            return;
        }
        stringBuffer = string2 != null ? stringBuffer.append("_CI") : stringBuffer.append("_CS");
        String string3 = this.BuildCreateIndexCommand(string, n, indexInfo, stringBuffer.toString(), string2);
        if (string3 != null) {
            this.arServerUser.getListSQL(string3, 1, false);
            List<StatusInfo> list = this.arServerUser.getLastStatus();
            if (!list.isEmpty()) {
                outputWriter.printHeader("", " Error while executing SQL Command: " + string3 + list.get(0).getMessageNum(), "\n");
            }
        }
    }

    private void dropCurrentDBIndex(String string) {
        String string2 = this.BuildDropIndexCommand(string);
        try {
            this.arServerUser.getListSQL(string2, 1, false);
        }
        catch (ARException aRException) {
            // empty catch block
        }
    }

    String BuildDropIndexCommand(String string) {
        StringBuilder stringBuilder = new StringBuilder("DROP INDEX " + string);
        return stringBuilder.toString();
    }

    String BuildCreateIndexCommand(String string, int n, IndexInfo indexInfo, String string2, String string3) throws ARException {
        boolean bl = false;
        List<Integer> list = indexInfo.getIndexFields();
        String string4 = "T" + n;
        String string5 = new String();
        string5 = indexInfo.isUnique() ? "CREATE UNIQUE INDEX " : "CREATE INDEX ";
        string5 = string5.concat(string2 + " ON " + string4 + " (");
        if (list.size() == 1) {
            FieldKey fieldKey = new FieldKey(string, list.get(0));
            FieldCriteria fieldCriteria = new FieldCriteria();
            fieldCriteria.setPropertiesToRetrieve(FieldCriteria.DATATYPE);
            Field field = this.arServerUser.getField(fieldKey.getFormName(), fieldKey.getFieldID(), fieldCriteria);
            if (field.getDataType() == 4) {
                bl = true;
            }
            if (string3 != null && field.getDataType() != 4) {
                return null;
            }
            string5 = string3 != null && bl ? string5.concat("nlssort(C" + list.get(0) + ", " + "'NLS_SORT=" + string3 + "'" + ")") : string5.concat("C" + list.get(0));
        } else {
            for (int i = 0; i < list.size(); ++i) {
                FieldKey fieldKey = new FieldKey(string, list.get(i));
                FieldCriteria fieldCriteria = new FieldCriteria();
                fieldCriteria.setPropertiesToRetrieve(FieldCriteria.DATATYPE);
                Field field = this.arServerUser.getField(fieldKey.getFormName(), fieldKey.getFieldID(), fieldCriteria);
                if (field.getDataType() == 4) {
                    bl = true;
                }
                if (i > 0) {
                    string5 = string5.concat(", ");
                }
                string5 = string3 != null && field.getDataType() == 4 ? string5.concat("(nlssort(C" + list.get(i).toString() + ", " + "'NLS_SORT=" + string3 + "'" + "))") : string5.concat("C" + list.get(i).toString());
            }
        }
        string5 = string5.concat(")");
        if (string3 != null && !bl) {
            return null;
        }
        return string5;
    }

    private void createDBIndexesForSchema(String string, String string2) throws ARException {
        Object object;
        Object object2;
        FormCriteria formCriteria = new FormCriteria();
        formCriteria.setPropertiesToRetrieve(FormCriteria.INDEX_LIST);
        Form form = this.arServerUser.getForm(string, formCriteria);
        if (form == null) {
            return;
        }
        int n = this.getSchemaIdForSchema(string);
        if (n == 0) {
            outputWriter.printHeader("", "Error while retrieving schema id for schema " + string + ".", "\n");
            return;
        }
        this.retrieveExistingIndexes(n);
        if (string2 != null) {
            object2 = "IT" + n + "_CI";
            if (!this.functionalIndexes.contains(object2)) {
                StringBuffer stringBuffer = new StringBuffer("CREATE UNIQUE INDEX " + (String)object2 + " ON T" + n + " (nlssort(C1, 'NLS_SORT=" + string2 + "'))");
                this.arServerUser.getListSQL(stringBuffer.toString(), 1, false);
                object = this.arServerUser.getLastStatus();
                if (!object.isEmpty()) {
                    outputWriter.printHeader("", " Error while executing SQL Command: " + stringBuffer + ((StatusInfo)object.get(0)).getMessageNum(), "\n");
                }
            } else {
                outputWriter.printHeader("", " Index " + (String)object2 + " already exists.", "\n");
            }
        }
        if ((object2 = form.getIndexInfo()) == null || object2.size() == 0) {
            outputWriter.printHeader("There are 0 indexes on the form", " ...skipping this form", "\n");
            return;
        }
        for (int i = 0; i < object2.size(); ++i) {
            object = (IndexInfo)object2.get(i);
            if (object == null) continue;
            this.createCurrentDBIndex(string, n, (IndexInfo)object, string2);
        }
    }

    private void dropDBIndexesForSchema(String string, boolean bl) throws ARException {
        int n;
        int n2 = this.getSchemaIdForSchema(string);
        if (n2 == 0) {
            outputWriter.printHeader("", "Error while retrieving schema id for schema " + string + ".", "\n");
            return;
        }
        String string2 = "IT" + n2;
        this.retrieveExistingIndexes(n2);
        if (bl) {
            if (this.functionalIndexes.size() == 0) {
                outputWriter.printHeader("There are 0 functional indexes on the form", " ... skipping this form", "\n");
                return;
            }
            for (n = 0; n < this.functionalIndexes.size(); ++n) {
                this.dropCurrentDBIndex(this.functionalIndexes.get(n));
            }
        } else {
            if (this.regularIndexes.size() == 0) {
                outputWriter.printHeader("There are 0 indexes on the form", " ... skipping this form", "\n");
                return;
            }
            for (n = 0; n < this.regularIndexes.size(); ++n) {
                if (this.regularIndexes.get(n).equals(string2)) continue;
                this.dropCurrentDBIndex(this.regularIndexes.get(n));
            }
        }
        if (!bl) {
            String string3 = new String(string2 + "_CI");
            for (int i = 0; i < this.functionalIndexes.size(); ++i) {
                String string4 = this.functionalIndexes.get(i);
                if (string4.equals(string3) || !string4.endsWith("_CI") || this.functionalIndexes.get(i).equals(string3)) continue;
                String string5 = string4.replace("_CI", "");
                StringBuffer stringBuffer = new StringBuffer("ALTER INDEX " + string4 + " RENAME TO " + string5);
                try {
                    this.arServerUser.getListSQL(stringBuffer.toString(), 1, false);
                    continue;
                }
                catch (ARException aRException) {
                    // empty catch block
                }
            }
        } else {
            String string6 = new String(string2 + "_CS");
            for (int i = 0; i < this.regularIndexes.size(); ++i) {
                String string7 = this.regularIndexes.get(i);
                if (string7.equals(string6) || !string7.endsWith("_CS") || this.regularIndexes.get(i).equals(string6)) continue;
                String string8 = string7.replace("_CS", "");
                StringBuffer stringBuffer = new StringBuffer("ALTER INDEX " + string7 + " RENAME TO " + string8);
                try {
                    this.arServerUser.getListSQL(stringBuffer.toString(), 1, false);
                    continue;
                }
                catch (ARException aRException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        OracleFunctionalIndexHelper oracleFunctionalIndexHelper = new OracleFunctionalIndexHelper();
        String string = null;
        try {
            JavaDriver.getThreadControlBlockPtr().setPrimaryThread(true);
            JavaDriver.getThreadControlBlockPtr().setCurrentInputToStdIn();
            JavaDriver.getThreadControlBlockPtr().setOutputToStdOut();
            outputWriter.printHeader("\t\t\t", "Oracle Functional Index Helper Utility", "\n");
            outputWriter.printHeader("\n", "===================================================================================================", "");
            outputWriter.printHeader("\n", "This is an un-supported convenience program which is being provide on ASIS basis to help customers", "");
            outputWriter.printHeader("\n", "in converting regular indexes to functional indexes and vice-versa. This utility is supposed to be ", "");
            outputWriter.printHeader("\n", "used in context of Oracle case insensitive search configuration in AR Server. The utility accepts an", "");
            outputWriter.printHeader("\n", "optional input argument which controls the forms which will be considered for index conversion. If the", "");
            outputWriter.printHeader("\n", "command line argument \"Input File containing the form names\" is not specified, the utility will be", "");
            outputWriter.printHeader("\n", "run on all the forms available on the server. The utility supports ADD, DROP and VIEW operations for", "");
            outputWriter.printHeader("\n", "indexes on the server. For ADD and DROP operations, index type (functional or regular) must be specified.", "");
            outputWriter.printHeader("\n", "The utility supports NLS_SORT parameters [BINARY_CI(0),BINARY_AI(1), GENERIC_M(2)] for case insensitive", "");
            outputWriter.printHeader("\n", "searches. The default value is BINARY_CI.", "\n");
            outputWriter.printHeader("\n", "The utility accepts following input values:", "");
            outputWriter.printHeader("\n\t", "Server Host: < name of the server, default is localhost >", "");
            outputWriter.printHeader("\n\t", "Server Port: < server port, default is 0 >", "");
            outputWriter.printHeader("\n\t", "User Name: < valid AR Server admin user >", "");
            outputWriter.printHeader("\n\t", "Password:  < AR Server admin password >", "");
            outputWriter.printHeader("\n\t", "Input File containing the form names: < Provide this argument to run on specific forms only>", "");
            outputWriter.printHeader("\n\t", "Index Operation Type: <Index operation type[Add(0),Drop(1),View(2), Exit(3)]>  ", "");
            outputWriter.printHeader("\n", "===================================================================================================", "\n\n");
            String string2 = InputReader.getString("Server Host:", "localhost");
            int n = InputReader.getInt("Server Port:", 0);
            String string3 = InputReader.getString("User Name:", "Demo");
            String string4 = InputReader.getString("Password:", "");
            String string5 = null;
            oracleFunctionalIndexHelper.arServerUser = new ARServerUser(string3, string4, string5, string2, n);
            try {
                oracleFunctionalIndexHelper.arServerUser.login();
                if (!oracleFunctionalIndexHelper.arServerUser.isAdministrator()) {
                    outputWriter.printHeader("*** ERROR ***", " Need AR Administrator privilege to run the utility", "\nIndex Helper utility stopped");
                    return;
                }
            }
            catch (ARException aRException) {
                String string6 = aRException.getMessage();
                outputWriter.printHeader("*** ERROR ***: Login failed for user: ", string3, "\n");
                if (string6 != null) {
                    outputWriter.printHeader(string6, "\n", "Index Helper utility stopped");
                }
                try {
                    oracleFunctionalIndexHelper.arServerUser.logout();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                finally {
                    System.exit(0);
                }
            }
            {
                oracleFunctionalIndexHelper.arServerUser.setTimeoutNormal(28800);
                oracleFunctionalIndexHelper.arServerUser.setTimeoutLong(28800);
                oracleFunctionalIndexHelper.arServerUser.setTimeoutXLong(28800);
            }
            InputReader.setNullPromptOption(true);
            String string7 = InputReader.getString("Input File containing the form names:", "");
            int[] nArray = new int[]{1};
            ServerInfoMap serverInfoMap = oracleFunctionalIndexHelper.arServerUser.getServerInfo(nArray);
            String string8 = ((Value)serverInfoMap.get(1)).toString();
            if (!string8.equals("SQL -- Oracle")) {
                outputWriter.printHeader("*** ERROR ***: Utility supports only Oracle Databse, underline DB detected: ", string8, "\nIndex Helper utility stopped");
                return;
            }
            int n2 = 2;
            int n3 = 0;
            try {
                oracleFunctionalIndexHelper.readSchemaNames(string7);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string9 = fileNotFoundException.getMessage();
                outputWriter.printHeader("*** ERROR ***: Invalid File: ", string7 != null ? string7 : "", "\n");
                if (string9 != null) {
                    outputWriter.printHeader(string9, "\n", "Index Helper utility stopped");
                }
                try {
                    oracleFunctionalIndexHelper.arServerUser.logout();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                finally {
                    System.exit(0);
                }
            }
            int n4 = 0;
            outputWriter.printHeader("", "Processing " + oracleFunctionalIndexHelper.getSchemaCount() + " Forms.", "\n");
            while (n2 != 3) {
                string = null;
                n2 = InputReader.getInt("Index Operation Type: [Add(0),Drop(1),View(2), Exit(3)]", 2);
                if (n2 < 0 || n2 > 3) {
                    if (n4 > 3) {
                        outputWriter.printHeader("*** ERROR ***: Invalid command option: ", "Max attempt", "\nIndex Helper utility stopped");
                        return;
                    }
                    outputWriter.printHeader("*** ERROR ***: Invalid command option: ", "", "\n");
                    ++n4;
                    continue;
                }
                n4 = 0;
                if (n2 == 0) {
                    n3 = InputReader.getInt("Index type to add: [REGULAR(0),FUNCTIONAL(1)]", 1);
                }
                if (n2 == 1 && (n3 = InputReader.getInt("Index type to drop: [REGULAR(0),FUNCTIONAL(1)]", 1)) == 0) {
                    string = null;
                }
                if (n2 == 0 && n3 == 1) {
                    int n5 = InputReader.getInt("NLS_SORT parameter: [BINARY_CI(0),BINARY_AI(1), GENERIC_M(2)", 0);
                    switch (n5) {
                        case 0: {
                            string = "BINARY_CI";
                            break;
                        }
                        case 1: {
                            string = "BINARY_AI";
                            break;
                        }
                        case 2: {
                            string = "GENERIC_M";
                            break;
                        }
                        default: {
                            string = "BINARY_CI";
                        }
                    }
                }
                Calendar calendar = Calendar.getInstance();
                long l = calendar.getTimeInMillis();
                switch (n2) {
                    case 0: {
                        oracleFunctionalIndexHelper.createDBIndexes(string);
                        break;
                    }
                    case 1: {
                        if (n3 == 1) {
                            oracleFunctionalIndexHelper.dropDBIndexes(true);
                            break;
                        }
                        oracleFunctionalIndexHelper.dropDBIndexes(false);
                        break;
                    }
                    case 2: {
                        oracleFunctionalIndexHelper.viewDBIndexes();
                        break;
                    }
                }
                calendar = Calendar.getInstance();
                long l2 = calendar.getTimeInMillis();
                long l3 = (l2 - l) / 1000L;
                outputWriter.printHeader("", "\n", "\n");
                outputWriter.printHeader("", "Current Run Report         \n", "\n");
                outputWriter.printHeader("", "==========================================", "\n");
                outputWriter.printHeader("", "Processing Completed in " + l3 + " seconds.", "\n");
                outputWriter.printHeader("", "==========================================", "\n");
            }
            return;
        }
        catch (Exception exception) {
            outputWriter.printString("Error in executing the command: ", exception.getMessage(), "\nIndex Helper utility stopped");
            return;
        }
        finally {
            try {
                oracleFunctionalIndexHelper.arServerUser.logout();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                System.exit(0);
            }
        }
    }
}

