/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;

public class XdrBufferDecodingStream
extends XdrDecodingStream {
    private byte[] buffer;
    private int encodedLength;
    private int bufferIndex;
    private int bufferHighmark;

    public XdrBufferDecodingStream(byte[] byArray, int n) {
        this.setXdrData(byArray, n);
    }

    public XdrBufferDecodingStream(byte[] byArray) {
        this.setXdrData(byArray, byArray.length);
    }

    public void setXdrData(byte[] byArray, int n) {
        if (n < 0 || (n & 3) != 0) {
            throw new IllegalArgumentException("length of encoded data must be a multiple of four and must not be negative");
        }
        this.buffer = byArray;
        this.encodedLength = n;
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    @Override
    public InetAddress getSenderAddress() {
        return null;
    }

    @Override
    public int getSenderPort() {
        return 0;
    }

    @Override
    public void beginDecoding() throws OncRpcException, IOException {
        this.bufferIndex = 0;
        this.bufferHighmark = this.encodedLength - 4;
    }

    @Override
    public void endDecoding() throws OncRpcException, IOException {
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    @Override
    public void close() throws OncRpcException, IOException {
        this.buffer = null;
    }

    @Override
    public int xdrDecodeInt() throws OncRpcException, IOException {
        if (this.bufferIndex <= this.bufferHighmark) {
            int n = this.buffer[this.bufferIndex++];
            n = (n << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            n = (n << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            n = (n << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            return n;
        }
        throw new OncRpcException(43);
    }

    @Override
    public byte[] xdrDecodeOpaque(int n) throws OncRpcException, IOException {
        int n2 = n;
        if ((n2 & 3) != 0) {
            n2 = (n2 & 0xFFFFFFFC) + 4;
        }
        byte[] byArray = new byte[n];
        if (n > 0) {
            if (this.bufferIndex <= this.bufferHighmark - n2 + 4) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n);
            } else {
                throw new OncRpcException(43);
            }
        }
        this.bufferIndex += n2;
        return byArray;
    }

    @Override
    public void xdrDecodeOpaque(byte[] byArray, int n, int n2) throws OncRpcException, IOException {
        int n3 = n2;
        if ((n3 & 3) != 0) {
            n3 = (n3 & 0xFFFFFFFC) + 4;
        }
        if (n2 > 0) {
            if (this.bufferIndex <= this.bufferHighmark - n3 + 4) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n, n2);
            } else {
                throw new OncRpcException(43);
            }
        }
        this.bufferIndex += n3;
    }
}

