/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import org.acplt.oncrpc.ArRpcBindHelper;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpSocketHelper;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;

public class OncRpcTcpClient
extends OncRpcClient {
    private static SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss.SSS");
    private static PrintWriter debugout = null;
    private Socket socket;
    private OncRpcTcpSocketHelper socketHelper;
    protected XdrTcpEncodingStream sendingXdr;
    protected XdrTcpDecodingStream receivingXdr;
    protected int transmissionTimeout = 30000;

    public OncRpcTcpClient(InetAddress inetAddress, int n, int n2) throws OncRpcException, IOException {
        this(inetAddress, n, n2, 0, 0);
    }

    public OncRpcTcpClient(InetAddress inetAddress, int n, int n2, int n3) throws OncRpcException, IOException {
        this(inetAddress, n, n2, n3, 0);
    }

    public OncRpcTcpClient(InetAddress inetAddress, int n, int n2, int n3, int n4) throws OncRpcException, IOException {
        this(inetAddress, n, n2, n3, n4, -1);
    }

    public OncRpcTcpClient(InetAddress inetAddress, int n, int n2, int n3, int n4, int n5) throws OncRpcException, IOException {
        super(inetAddress, n, n2, n3, 6);
        if (n4 == 0) {
            n4 = 8192;
        }
        if (n4 < 1024) {
            n4 = 1024;
        }
        this.socketHelper = new OncRpcTcpSocketHelper();
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("client will connect to " + inetAddress + ":" + this.port);
        }
        this.socket = this.socketHelper.connect(inetAddress, this.port, n5);
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("client bound to " + this.socket);
            System.out.println("with localInetAddress: " + this.socket.getLocalSocketAddress() + "; remoteInetAddress: " + this.socket.getRemoteSocketAddress());
        }
        this.socket.setTcpNoDelay(true);
        if (this.socketHelper.getSendBufferSize() < n4) {
            this.socketHelper.setSendBufferSize(n4);
        }
        if (this.socketHelper.getReceiveBufferSize() < n4) {
            this.socketHelper.setReceiveBufferSize(n4);
        }
        this.sendingXdr = this.aNewXdrTcpEncodingStream(null, this.socket, n4);
        this.receivingXdr = this.aNewXdrTcpDecodingStream(null, this.socket, n4);
    }

    @Override
    public void close() throws OncRpcException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sendingXdr = null;
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.receivingXdr = null;
        }
    }

    @Override
    public synchronized void call(int n, int n2, XdrAble xdrAble, XdrAble xdrAble2) throws OncRpcException {
        for (int i = 1; i >= 0; --i) {
            String string;
            this.nextXid();
            OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, n2, n, this.auth);
            OncRpcClientReplyMessage oncRpcClientReplyMessage = new OncRpcClientReplyMessage(this.auth);
            try {
                if (debugout != null) {
                    string = "call: ProcNumber=" + n + " Sending...." + " msgId=" + this.xid;
                    string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
                    debugout.println(string);
                }
                this.socket.setSoTimeout(this.transmissionTimeout);
                this.beginEncoding(n, null, 0);
                oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
                this.encodeParams(xdrAble);
                if (this.timeout != 0) {
                    this.sendingXdr.endEncoding();
                } else {
                    this.sendingXdr.endEncoding(false);
                }
            }
            catch (IOException iOException) {
                throw new OncRpcException(3, iOException.getLocalizedMessage());
            }
            finally {
                try {
                    this.endEncoding(n);
                }
                catch (IOException iOException) {
                    throw new OncRpcException(3, iOException.getLocalizedMessage());
                }
            }
            if (this.timeout == 0) {
                return;
            }
            try {
                if (debugout != null) {
                    string = "call: ProcNumber=" + n + " Receiving....";
                    string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
                    debugout.println(string);
                }
                while (true) {
                    this.socket.setSoTimeout(this.timeout);
                    this.beginDecoding(n);
                    this.socket.setSoTimeout(this.transmissionTimeout);
                    try {
                        oncRpcClientReplyMessage.xdrDecode(this.receivingXdr);
                    }
                    catch (OncRpcException oncRpcException) {
                        this.receivingXdr.endDecoding();
                        throw oncRpcException;
                    }
                    if (debugout != null) {
                        string = "call: ProcNumber=" + n + " Received msgId=" + oncRpcClientReplyMessage.messageId;
                        string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
                        debugout.println(string);
                    }
                    if (oncRpcClientReplyMessage.messageId == oncRpcClientCallMessage.messageId) break;
                    if (debugout != null) {
                        string = "call: ProcNumber=" + n + " mismatched msgId. try again!";
                        string = "/* " + formatter.format(System.currentTimeMillis()) + " */" + string;
                        debugout.println(string);
                    }
                    this.receivingXdr.endDecoding();
                }
                if (!oncRpcClientReplyMessage.successfullyAccepted()) {
                    this.receivingXdr.endDecoding();
                    if (i > 0 && oncRpcClientReplyMessage.replyStatus == 1 && oncRpcClientReplyMessage.rejectStatus == 1 && this.auth != null && this.auth.canRefreshCred()) continue;
                    throw oncRpcClientReplyMessage.newException();
                }
                try {
                    this.decodeResult(xdrAble2);
                }
                catch (OncRpcException oncRpcException) {
                    this.receivingXdr.endDecoding();
                    throw oncRpcException;
                }
                this.receivingXdr.endDecoding();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new OncRpcTimeoutException();
            }
            catch (IOException iOException) {
                throw new OncRpcException(4, iOException.getLocalizedMessage());
            }
            finally {
                try {
                    this.endDecoding(n);
                }
                catch (IOException iOException) {
                    throw new OncRpcException(4, iOException.getLocalizedMessage());
                }
            }
        }
    }

    public synchronized void batchCall(int n, XdrAble xdrAble, boolean bl) throws OncRpcException {
        this.nextXid();
        OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, this.version, n, this.auth);
        try {
            this.socket.setSoTimeout(this.transmissionTimeout);
            this.beginEncoding(n, null, 0);
            oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
            xdrAble.xdrEncode(this.sendingXdr);
            this.sendingXdr.endEncoding(bl);
        }
        catch (IOException iOException) {
            throw new OncRpcException(3, iOException.getLocalizedMessage());
        }
        finally {
            try {
                this.endEncoding(n);
            }
            catch (IOException iOException) {
                throw new OncRpcException(3, iOException.getLocalizedMessage());
            }
        }
    }

    @Override
    public void setTimeout(int n) {
        super.setTimeout(n);
    }

    public void setTransmissionTimeout(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = n;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    @Override
    public void setCharacterEncoding(String string) {
        this.receivingXdr.setCharacterEncoding(string);
        this.sendingXdr.setCharacterEncoding(string);
    }

    @Override
    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void encodeParams(XdrAble xdrAble) throws OncRpcException, IOException {
        xdrAble.xdrEncode(this.sendingXdr);
    }

    public void decodeResult(XdrAble xdrAble) throws OncRpcException, IOException {
        xdrAble.xdrDecode(this.receivingXdr);
    }

    protected OncRpcTcpSocketHelper getSocketHelper() {
        return this.socketHelper;
    }

    protected void beginDecoding(int n) throws IOException, OncRpcException {
        this.receivingXdr.beginDecoding();
    }

    protected void endDecoding(int n) throws IOException, OncRpcException {
    }

    protected void beginEncoding(int n, InetAddress inetAddress, int n2) throws IOException, OncRpcException {
        this.sendingXdr.beginEncoding(inetAddress, n2);
    }

    protected void endEncoding(int n) throws IOException, OncRpcException {
    }

    protected XdrTcpEncodingStream aNewXdrTcpEncodingStream(Object object, Socket socket, int n) throws IOException {
        this.sendingXdr = new XdrTcpEncodingStream(socket, n);
        return this.sendingXdr;
    }

    protected XdrTcpDecodingStream aNewXdrTcpDecodingStream(Object object, Socket socket, int n) throws IOException {
        this.receivingXdr = new XdrTcpDecodingStream(socket, n);
        return this.receivingXdr;
    }
}

