/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.core;

import com.bmc.thirdparty.org.springframework.jdbc.core.ResultSetExtractor;
import com.bmc.thirdparty.org.springframework.jdbc.core.RowCallbackHandler;
import com.bmc.thirdparty.org.springframework.jdbc.core.RowMapper;
import com.bmc.thirdparty.org.springframework.jdbc.core.SqlParameter;

public class ResultSetSupportingSqlParameter
extends SqlParameter {
    private ResultSetExtractor resultSetExtractor;
    private RowCallbackHandler rowCallbackHandler;
    private RowMapper rowMapper;

    public ResultSetSupportingSqlParameter(String name, int sqlType) {
        super(name, sqlType);
    }

    public ResultSetSupportingSqlParameter(String name, int sqlType, String typeName) {
        super(name, sqlType, typeName);
    }

    public ResultSetSupportingSqlParameter(String name, int sqlType, ResultSetExtractor rse) {
        super(name, sqlType);
        this.resultSetExtractor = rse;
    }

    public ResultSetSupportingSqlParameter(String name, int sqlType, RowCallbackHandler rch) {
        super(name, sqlType);
        this.rowCallbackHandler = rch;
    }

    public ResultSetSupportingSqlParameter(String name, int sqlType, RowMapper rm) {
        super(name, sqlType);
        this.rowMapper = rm;
    }

    public boolean isResultSetSupported() {
        return this.resultSetExtractor != null || this.rowCallbackHandler != null || this.rowMapper != null;
    }

    public ResultSetExtractor getResultSetExtractor() {
        return this.resultSetExtractor;
    }

    public RowCallbackHandler getRowCallbackHandler() {
        return this.rowCallbackHandler;
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }
}

