/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.Config;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class LoggingInfo
implements Serializable {
    private static final long serialVersionUID = -2184816770940532956L;
    private static Logger a = Logger.getLogger(LoggingInfo.class);
    private boolean m_isEnabled;
    private long m_type;
    private long m_writeToFileOrStatus;
    private String m_fileNameWithPath;
    private PrintStream m_printStream;

    public LoggingInfo() {
        this.m_isEnabled = false;
        this.m_type = 0L;
        this.m_writeToFileOrStatus = 0L;
        this.m_fileNameWithPath = null;
    }

    public LoggingInfo(boolean bl, long l2, long l3, String string) {
        this.m_isEnabled = bl;
        this.m_type = l2;
        this.m_writeToFileOrStatus = l3;
        this.m_fileNameWithPath = string;
    }

    public void enable(boolean bl) {
        this.m_isEnabled = bl;
    }

    public void setType(long l2) {
        this.m_type = l2;
    }

    public void setWriteToFileOrStatus(long l2) {
        this.m_writeToFileOrStatus = l2;
    }

    public void setPath(String string) {
        this.m_fileNameWithPath = string;
    }

    public boolean isEnabled() {
        return this.m_isEnabled;
    }

    public long getType() {
        return this.m_type;
    }

    public long getWriteToFileOrStatus() {
        return this.m_writeToFileOrStatus;
    }

    public String getPath() {
        return this.m_fileNameWithPath;
    }

    public boolean isWorkflowMaskOn() {
        return (this.m_type & 1L) != 0L || (this.m_type & 0x10L) != 0L || (this.m_type & 2L) != 0L;
    }

    public boolean log(String string) {
        if (!this.isEnabled() || !this.isWorkflowMaskOn()) {
            return false;
        }
        if ((this.m_writeToFileOrStatus & 1L) != 0L) {
            try {
                if (this.m_printStream == null) {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.m_fileNameWithPath);
                    this.m_printStream = new PrintStream(fileOutputStream);
                }
                this.m_printStream.println(string);
            }
            catch (IOException iOException) {
                a.error("IOException  while trying to write file", iOException);
            }
        }
        return (this.m_writeToFileOrStatus & 2L) == 0L;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Is Enabled", this.m_isEnabled).append("Type", this.m_type).append("Write To File Or Status", this.m_writeToFileOrStatus).append("File Name With Path", this.m_fileNameWithPath).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_isEnabled).append(this.m_type).append(this.m_writeToFileOrStatus).append(this.m_fileNameWithPath).toHashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LoggingInfo)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        LoggingInfo loggingInfo = (LoggingInfo)object;
        return new EqualsBuilder().append(this.m_isEnabled, loggingInfo.m_isEnabled).append(this.m_type, loggingInfo.m_type).append(this.m_writeToFileOrStatus, loggingInfo.m_writeToFileOrStatus).append(this.m_fileNameWithPath, loggingInfo.m_fileNameWithPath).isEquals();
    }
}

