/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.view.jasperreports;

import com.bmc.thirdparty.org.springframework.ui.jasperreports.JasperReportsUtils;
import com.bmc.thirdparty.org.springframework.web.servlet.view.jasperreports.AbstractJasperReportsView;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;

public abstract class AbstractJasperReportsSingleFormatView
extends AbstractJasperReportsView {
    private static final int OUTPUT_BYTE_ARRAY_INITIAL_SIZE = 4096;

    protected void renderReport(JasperPrint populatedReport, Map model, HttpServletResponse response) throws Exception {
        JRExporter exporter = this.createExporter();
        Map mergedExporterParameters = this.mergeExporterParameters(model);
        if (mergedExporterParameters != null) {
            exporter.setParameters(mergedExporterParameters);
        }
        if (this.useWriter()) {
            String contentType = this.getContentType();
            String encoding = (String)exporter.getParameter(JRExporterParameter.CHARACTER_ENCODING);
            if (encoding != null && contentType != null && contentType.toLowerCase().indexOf(";charset=") == -1) {
                contentType = contentType + ";charset=" + encoding;
            }
            response.setContentType(contentType);
            JasperReportsUtils.render(exporter, populatedReport, response.getWriter());
        } else {
            response.setContentType(this.getContentType());
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            JasperReportsUtils.render(exporter, populatedReport, baos);
            response.setContentLength(baos.size());
            ServletOutputStream out = response.getOutputStream();
            baos.writeTo((OutputStream)out);
            out.flush();
        }
    }

    protected Map mergeExporterParameters(Map model) {
        HashMap mergedParameters = new HashMap();
        if (this.getConvertedExporterParameters() != null) {
            mergedParameters.putAll(this.getConvertedExporterParameters());
        }
        Iterator iterator = model.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (!(key instanceof JRExporterParameter)) continue;
            Object value = model.get(key);
            if (value instanceof String) {
                mergedParameters.put(key, value);
                continue;
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn("Ignoring exporter parameter [" + key + "]: value is not a String");
        }
        return mergedParameters;
    }

    protected abstract JRExporter createExporter();

    protected abstract boolean useWriter();
}

