/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.i18n;

import com.bmc.thirdparty.org.springframework.beans.propertyeditors.LocaleEditor;
import com.bmc.thirdparty.org.springframework.web.servlet.LocaleResolver;
import com.bmc.thirdparty.org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import com.bmc.thirdparty.org.springframework.web.servlet.support.RequestContextUtils;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LocaleChangeInterceptor
extends HandlerInterceptorAdapter {
    public static final String DEFAULT_PARAM_NAME = "locale";
    private String paramName = "locale";

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        String newLocale = request.getParameter(this.paramName);
        if (newLocale != null) {
            LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver(request);
            if (localeResolver == null) {
                throw new IllegalStateException("No LocaleResolver found: not in a DispatcherServlet request?");
            }
            LocaleEditor localeEditor = new LocaleEditor();
            localeEditor.setAsText(newLocale);
            localeResolver.setLocale(request, response, (Locale)localeEditor.getValue());
        }
        return true;
    }
}

