/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.xml;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.BeanUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.NamespaceHandler;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import com.bmc.thirdparty.org.springframework.core.io.support.PropertiesLoaderUtils;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DefaultNamespaceHandlerResolver
implements NamespaceHandlerResolver {
    private static final String SPRING_HANDLER_MAPPINGS_LOCATION = "META-INF/spring.handlers";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map handlerMappings;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$NamespaceHandler;

    public DefaultNamespaceHandlerResolver() {
        this(null, SPRING_HANDLER_MAPPINGS_LOCATION);
    }

    public DefaultNamespaceHandlerResolver(ClassLoader classLoader) {
        this(classLoader, SPRING_HANDLER_MAPPINGS_LOCATION);
    }

    public DefaultNamespaceHandlerResolver(ClassLoader classLoader, String handlerMappingsLocation) {
        Assert.notNull(handlerMappingsLocation, "Handler mappings location must not be null");
        ClassLoader classLoaderToUse = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
        this.initHandlerMappings(classLoaderToUse, handlerMappingsLocation);
    }

    private void initHandlerMappings(ClassLoader classLoader, String handlerMappingsLocation) {
        Properties mappings = this.loadMappings(classLoader, handlerMappingsLocation);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loaded mappings [" + mappings + "]");
        }
        this.handlerMappings = new HashMap(mappings.size());
        Enumeration<?> en = mappings.propertyNames();
        while (en.hasMoreElements()) {
            String namespaceUri = (String)en.nextElement();
            String className = mappings.getProperty(namespaceUri);
            try {
                Class handlerClass = ClassUtils.forName(className, classLoader);
                if (!(class$org$springframework$beans$factory$xml$NamespaceHandler == null ? DefaultNamespaceHandlerResolver.class$("com.bmc.thirdparty.org.springframework.beans.factory.xml.NamespaceHandler") : class$org$springframework$beans$factory$xml$NamespaceHandler).isAssignableFrom(handlerClass)) {
                    throw new IllegalArgumentException("Class [" + className + "] does not implement the NamespaceHandler interface");
                }
                NamespaceHandler namespaceHandler = (NamespaceHandler)BeanUtils.instantiateClass(handlerClass);
                namespaceHandler.init();
                this.handlerMappings.put(namespaceUri, namespaceHandler);
            }
            catch (ClassNotFoundException ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Ignoring handler [" + className + "]: class not found", ex);
            }
            catch (LinkageError ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Ignoring handler [" + className + "]: problem with class file or dependent class", ex);
            }
        }
    }

    private Properties loadMappings(ClassLoader classLoader, String handlerMappingsLocation) {
        try {
            return PropertiesLoaderUtils.loadAllProperties(handlerMappingsLocation, classLoader);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load NamespaceHandler mappings from location [" + handlerMappingsLocation + "]. Root cause: " + ex);
        }
    }

    public NamespaceHandler resolve(String namespaceUri) {
        return (NamespaceHandler)this.handlerMappings.get(namespaceUri);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

