/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.support;

import com.bmc.thirdparty.org.springframework.beans.factory.support.MethodOverride;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public class ReplaceOverride
extends MethodOverride {
    private final String methodReplacerBeanName;
    private List typeIdentifiers = new LinkedList();

    public ReplaceOverride(String methodName, String methodReplacerBeanName) {
        super(methodName);
        this.methodReplacerBeanName = methodReplacerBeanName;
    }

    public String getMethodReplacerBeanName() {
        return this.methodReplacerBeanName;
    }

    public void addTypeIdentifier(String s) {
        this.typeIdentifiers.add(s);
    }

    public boolean matches(Method method) {
        if (!method.getName().equals(this.getMethodName())) {
            return false;
        }
        if (!this.isOverloaded()) {
            return true;
        }
        if (this.typeIdentifiers.size() != method.getParameterTypes().length) {
            return false;
        }
        for (int i2 = 0; i2 < this.typeIdentifiers.size(); ++i2) {
            String identifier = (String)this.typeIdentifiers.get(i2);
            if (method.getParameterTypes()[i2].getName().indexOf(identifier) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o2) {
        if (!super.equals(o2)) {
            return false;
        }
        ReplaceOverride that = (ReplaceOverride)o2;
        if (!ObjectUtils.nullSafeEquals(this.methodReplacerBeanName, that.methodReplacerBeanName)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.typeIdentifiers, that.typeIdentifiers);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + ObjectUtils.nullSafeHashCode(this.methodReplacerBeanName);
        result = 29 * result + ObjectUtils.nullSafeHashCode(this.typeIdentifiers);
        return result;
    }

    public String toString() {
        return "Replace override for method '" + this.getMethodName() + "; will call bean '" + this.methodReplacerBeanName + "'";
    }
}

