/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.digester.plugins.strategies;

import com.bmc.thirdparty.org.apache.commons.digester.Digester;
import com.bmc.thirdparty.org.apache.commons.digester.plugins.PluginException;
import com.bmc.thirdparty.org.apache.commons.digester.plugins.RuleFinder;
import com.bmc.thirdparty.org.apache.commons.digester.plugins.RuleLoader;
import com.bmc.thirdparty.org.apache.commons.digester.plugins.strategies.LoaderFromStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FinderFromResource
extends RuleFinder {
    public static String DFLT_RESOURCE_ATTR = "resource";
    private String resourceAttr;

    public FinderFromResource() {
        this(DFLT_RESOURCE_ATTR);
    }

    public FinderFromResource(String resourceAttr) {
        this.resourceAttr = resourceAttr;
    }

    public RuleLoader findLoader(Digester d2, Class pluginClass, Properties p) throws PluginException {
        String resourceName = p.getProperty(this.resourceAttr);
        if (resourceName == null) {
            return null;
        }
        InputStream is = pluginClass.getClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            throw new PluginException("Resource " + resourceName + " not found.");
        }
        return FinderFromResource.loadRules(d2, pluginClass, is, resourceName);
    }

    public static RuleLoader loadRules(Digester d2, Class pluginClass, InputStream is, String resourceName) throws PluginException {
        try {
            LoaderFromStream loader;
            LoaderFromStream loaderFromStream = loader = new LoaderFromStream(is);
            return loaderFromStream;
        }
        catch (Exception e2) {
            throw new PluginException("Unable to load xmlrules from resource [" + resourceName + "]", e2);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                throw new PluginException("Unable to close stream for resource [" + resourceName + "]", ioe);
            }
        }
    }
}

