/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrUdpEncodingStream
extends XdrEncodingStream {
    private DatagramSocket socket;
    private InetAddress receiverAddress = null;
    private int receiverPort = 0;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public XdrUdpEncodingStream(DatagramSocket datagramSocket, int bufferSize) {
        this.socket = datagramSocket;
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        if ((bufferSize & 3) != 0) {
            bufferSize = bufferSize + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[bufferSize];
        this.bufferIndex = 0;
        this.bufferHighmark = bufferSize - 4;
    }

    @Override
    public void beginEncoding(InetAddress receiverAddress, int receiverPort) throws OncRpcException, IOException {
        this.receiverAddress = receiverAddress;
        this.receiverPort = receiverPort;
        this.bufferIndex = 0;
    }

    @Override
    public void endEncoding() throws OncRpcException, IOException {
        DatagramPacket packet = new DatagramPacket(this.buffer, this.bufferIndex, this.receiverAddress, this.receiverPort);
        this.socket.send(packet);
    }

    @Override
    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.socket = null;
    }

    @Override
    public void xdrEncodeInt(int value) throws OncRpcException, IOException {
        if (this.bufferIndex > this.bufferHighmark) {
            throw new OncRpcException(42);
        }
        this.buffer[this.bufferIndex++] = (byte)(value >>> 24);
        this.buffer[this.bufferIndex++] = (byte)(value >>> 16);
        this.buffer[this.bufferIndex++] = (byte)(value >>> 8);
        this.buffer[this.bufferIndex++] = (byte)value;
    }

    @Override
    public void xdrEncodeOpaque(byte[] value, int offset, int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        if (this.bufferIndex <= this.bufferHighmark - (length + padding)) {
            System.arraycopy(value, offset, this.buffer, this.bufferIndex, length);
            this.bufferIndex += length;
            if (padding != 0) {
                System.arraycopy(paddingZeros, 0, this.buffer, this.bufferIndex, padding);
                this.bufferIndex += padding;
            }
        } else {
            throw new OncRpcException(42);
        }
    }
}

