/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.codec.net;

import com.bmc.thirdparty.org.apache.commons.codec.BinaryDecoder;
import com.bmc.thirdparty.org.apache.commons.codec.BinaryEncoder;
import com.bmc.thirdparty.org.apache.commons.codec.DecoderException;
import com.bmc.thirdparty.org.apache.commons.codec.EncoderException;
import com.bmc.thirdparty.org.apache.commons.codec.StringDecoder;
import com.bmc.thirdparty.org.apache.commons.codec.StringEncoder;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URLCodec
implements BinaryEncoder,
BinaryDecoder,
StringEncoder,
StringDecoder {
    protected String charset = "UTF-8";
    protected static byte ESCAPE_CHAR;
    protected static final BitSet WWW_FORM_URL;

    public URLCodec() {
    }

    public URLCodec(String charset) {
        this.charset = charset;
    }

    public static final byte[] encodeUrl(BitSet urlsafe, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (urlsafe == null) {
            urlsafe = WWW_FORM_URL;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            int b2 = bytes[i2];
            if (b2 < 0) {
                b2 = 256 + b2;
            }
            if (urlsafe.get(b2)) {
                if (b2 == 32) {
                    b2 = 43;
                }
                buffer.write(b2);
                continue;
            }
            buffer.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b2 >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b2 & 0xF, 16));
            buffer.write(hex1);
            buffer.write(hex2);
        }
        return buffer.toByteArray();
    }

    public static final byte[] decodeUrl(byte[] bytes) throws DecoderException {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            byte b2 = bytes[i2];
            if (b2 == 43) {
                buffer.write(32);
                continue;
            }
            if (b2 == 37) {
                try {
                    int u = Character.digit((char)bytes[++i2], 16);
                    int l2 = Character.digit((char)bytes[++i2], 16);
                    if (u == -1 || l2 == -1) {
                        throw new DecoderException("Invalid URL encoding");
                    }
                    buffer.write((char)((u << 4) + l2));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    throw new DecoderException("Invalid URL encoding");
                }
            }
            buffer.write(b2);
        }
        return buffer.toByteArray();
    }

    public byte[] encode(byte[] bytes) {
        return URLCodec.encodeUrl(WWW_FORM_URL, bytes);
    }

    public byte[] decode(byte[] bytes) throws DecoderException {
        return URLCodec.decodeUrl(bytes);
    }

    public String encode(String pString, String charset) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return new String(this.encode(pString.getBytes(charset)), "US-ASCII");
    }

    public String encode(String pString) throws EncoderException {
        if (pString == null) {
            return null;
        }
        try {
            return this.encode(pString, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException e2) {
            throw new EncoderException(e2.getMessage());
        }
    }

    public String decode(String pString, String charset) throws DecoderException, UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        return new String(this.decode(pString.getBytes("US-ASCII")), charset);
    }

    public String decode(String pString) throws DecoderException {
        if (pString == null) {
            return null;
        }
        try {
            return this.decode(pString, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException e2) {
            throw new DecoderException(e2.getMessage());
        }
    }

    public Object encode(Object pObject) throws EncoderException {
        if (pObject == null) {
            return null;
        }
        if (pObject instanceof byte[]) {
            return this.encode((byte[])pObject);
        }
        if (pObject instanceof String) {
            return this.encode((String)pObject);
        }
        throw new EncoderException("Objects of type " + pObject.getClass().getName() + " cannot be URL encoded");
    }

    public Object decode(Object pObject) throws DecoderException {
        if (pObject == null) {
            return null;
        }
        if (pObject instanceof byte[]) {
            return this.decode((byte[])pObject);
        }
        if (pObject instanceof String) {
            return this.decode((String)pObject);
        }
        throw new DecoderException("Objects of type " + pObject.getClass().getName() + " cannot be URL decoded");
    }

    public String getEncoding() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset;
    }

    static {
        int i2;
        ESCAPE_CHAR = (byte)37;
        WWW_FORM_URL = new BitSet(256);
        for (i2 = 97; i2 <= 122; ++i2) {
            WWW_FORM_URL.set(i2);
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            WWW_FORM_URL.set(i2);
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            WWW_FORM_URL.set(i2);
        }
        WWW_FORM_URL.set(45);
        WWW_FORM_URL.set(95);
        WWW_FORM_URL.set(46);
        WWW_FORM_URL.set(42);
        WWW_FORM_URL.set(32);
    }
}

