/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.nio;

import com.bmc.arsys.arrpc.nio.ArEncryptionInfoI;
import com.bmc.arsys.arthreadlocal.ARThreadLocalStorageBlock;
import com.bmc.arsys.artranscode.ARCharSet;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ConcurrentHashMap;
import org.acplt.oncrpc.XdrDecodingStream;
import org.apache.log4j.Logger;

public abstract class ArConnectionInfo
implements ArEncryptionInfoI {
    private static Logger a = Logger.getLogger(ArConnectionInfo.class);
    public static ConcurrentHashMap<String, String> connection_CharSetMap = new ConcurrentHashMap();

    public static boolean isRemoteHostCharSetExist(String string) {
        if (string == null) {
            return false;
        }
        return connection_CharSetMap.containsKey(string);
    }

    public static String getRemoteHostCharSet(String string) {
        String string2 = null;
        if (string != null) {
            string2 = connection_CharSetMap.get(string);
        }
        if (string2 == null) {
            string2 = "utf-8";
        }
        return string2;
    }

    public static void setRemoteHostCharSet(String string, String string2) {
        if (string != null) {
            connection_CharSetMap.put(string, string2);
        }
    }

    public static boolean isRemoteHostCodeSetExist() {
        String string = ARThreadLocalStorageBlock.getTLB().getCurrentRemoteHostKey();
        if (string == null) {
            return false;
        }
        return connection_CharSetMap.containsKey(string);
    }

    public static void setRemoteHostCharSet(String string) {
        String string2 = ARThreadLocalStorageBlock.getTLB().getCurrentRemoteHostKey();
        ArConnectionInfo.setRemoteHostCharSet(string2, string);
    }

    public static void updateRemoteHostInfoFromRpcControlStruct(byte[] byArray, XdrDecodingStream xdrDecodingStream) {
        String string = ArConnectionInfo.getRemoteHostLanguageStr(byArray);
        xdrDecodingStream.setCharacterEncoding(string);
        ARThreadLocalStorageBlock.getTLB().setRemoteHostCharSet(string);
        if (a.isTraceEnabled()) {
            String string2 = ARThreadLocalStorageBlock.getTLB().getCurrentRemoteHostKey();
            a.trace("++++++++++set remote host " + string2 + "  encoding " + string);
        }
    }

    static String getRemoteHostLanguageStr(byte[] byArray) {
        String string = null;
        try {
            string = StringByteUtil.createNullTerminatedString(byArray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            a.trace(unsupportedEncodingException.getLocalizedMessage());
        }
        String string2 = ARCharSet.getServerCharSetName(string);
        if (a.isTraceEnabled()) {
            a.trace("RemoteHostLanguage " + string + ", CharSet " + string2);
        }
        if (!ArConnectionInfo.isRemoteHostCodeSetExist()) {
            ArConnectionInfo.setRemoteHostCharSet(string2);
        }
        return string2;
    }
}

