/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.demo.javadriver.InputFile;
import com.bmc.arsys.demo.javadriver.SyncObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Stack;

public class ThreadControlBlock {
    ARServerUser context = null;
    String currentInputFileName = null;
    Stack<InputFile> inFile = new Stack();
    PrintWriter outFile;
    boolean isStdOut = false;
    PrintWriter recordFile;
    PrintWriter loggingFile;
    String buffer;
    String args;
    boolean primaryThread;
    String outFileName;
    String firstListId;
    String secondListId;
    String lastListId;
    String currCommand;
    int numFailedBeginLoop;
    int currentLoopDepth;
    int[] numIterations;
    long[] loopBeginFilePos;
    Stack<Object> threadHandles = null;
    SyncObject waitObject = new SyncObject(false);
    SyncObject releaseObject = new SyncObject(false);

    public ARServerUser getContext() {
        return this.context;
    }

    public String getFirstListId() {
        return this.firstListId;
    }

    public String getLastListId() {
        return this.lastListId;
    }

    public String getSecondListId() {
        return this.secondListId;
    }

    public String getCurrentCommand() {
        return this.currCommand;
    }

    public void setBuffer(String content) {
        this.buffer = content;
    }

    public void resetListIds() {
        this.firstListId = null;
        this.secondListId = null;
        this.lastListId = null;
    }

    public void setFirstListId(String id) {
        this.firstListId = id;
    }

    public void setLastListId(String id) {
        this.lastListId = id;
    }

    public void setSecondListId(String id) {
        this.secondListId = id;
    }

    public void setCurrentInputFileReadingPostion(long filePosition) throws IOException, FileNotFoundException {
        InputFile fp = this.inFile.pop();
        if (fp.isFileStdIn()) {
            this.inFile.push(fp);
        } else {
            String name = fp.getFileName();
            fp.close();
            this.inFile.push(new InputFile(name));
            long currentPos = 0L;
            BufferedReader reader = this.getCurrentInputFile();
            String inputLine = null;
            do {
                if ((inputLine = reader.readLine()) == null) continue;
                currentPos += (long)inputLine.length();
            } while (currentPos < filePosition);
            this.setCurrentInputFilePosition(currentPos);
        }
    }

    public void setCurrentInputFilePosition(long pos) {
        InputFile fp = this.inFile.peek();
        fp.setCurrentPosition(pos);
    }

    public void addToCurrentInputFilePosition(long increment) {
        InputFile fp = this.inFile.peek();
        fp.addToCurrentPosition(increment);
    }

    public long getCurrentInputFilePos() {
        InputFile fp = this.inFile.peek();
        return fp.getCurrentPosition();
    }

    public void setLoopBeginFilePos(int index, long filePosition) {
        this.loopBeginFilePos[index] = filePosition;
    }

    public long getLoopBeginFilePos(int index) {
        return this.loopBeginFilePos[index];
    }

    public void setNumberOfIterations(int index, int iterations) {
        this.numIterations[index] = iterations;
    }

    public int getNumberOfIterations(int index) {
        return this.numIterations[index];
    }

    public void reduceNumberOfIterations(int index) {
        this.numIterations[index] = this.numIterations[index] - 1;
    }

    public void incrementNumFailedBeginLoop() {
        ++this.numFailedBeginLoop;
    }

    public void reduceNumFailedBeginLoop() {
        --this.numFailedBeginLoop;
    }

    public int getNumFailedBeginLoop() {
        return this.numFailedBeginLoop;
    }

    public int getCurrentLoopDepth() {
        return this.currentLoopDepth;
    }

    public void incrementCurrentLoopDepth() {
        ++this.currentLoopDepth;
    }

    public void reduceCurrentLoopDepth() {
        --this.currentLoopDepth;
    }

    public void addThreadHandle(Object handle) {
        if (this.threadHandles == null) {
            this.threadHandles = new Stack();
        }
        this.threadHandles.push(handle);
    }

    public Object getThreadHandle() {
        if (this.threadHandles != null && !this.threadHandles.isEmpty()) {
            return this.threadHandles.peek();
        }
        return null;
    }

    public void deleteThreadHandle() {
        if (this.threadHandles != null) {
            this.threadHandles.pop();
        }
    }

    public ThreadControlBlock() {
        this.numIterations = new int[10];
        this.loopBeginFilePos = new long[10];
        this.context = new ARServerUser();
        this.resetListIds();
    }

    public SyncObject getWaitObject() {
        return this.waitObject;
    }

    public SyncObject getReleaseObject() {
        return this.releaseObject;
    }

    public void setWaitObjectToNull() {
        this.waitObject = null;
    }

    public void setReleaseObjectToNull() {
        this.releaseObject = null;
    }

    public boolean isCurrentInputSourceStdInput() {
        InputFile fp = this.inFile.peek();
        return fp.isFileStdIn();
    }

    public void setAuthentication(String authString) {
        this.context.setAuthentication(authString);
    }

    public void setUser(String name) {
        this.context.setUser(name);
    }

    public void setLocale(String locale) {
        this.context.setLocale(locale);
    }

    public void setTimeZone(String timeZone) {
        this.context.setTimeZone(timeZone);
    }

    public void setPassword(String password) {
        this.context.setPassword(password);
    }

    public void setServer(String server) {
        this.context.setServer(server);
    }

    public void setPort(int portNumber) {
        this.context.setPort(portNumber);
    }

    public void setPrivateRpcQueue(int progNumber) {
        try {
            this.context.usePrivateRpcQueue(progNumber);
        }
        catch (ARException e2) {
            System.out.println("ARException :" + e2);
        }
    }

    public String getBuffer() {
        return this.buffer;
    }

    public void setCurrentCommand(String command) {
        this.currCommand = command;
    }

    public void setArgs(String argsString) {
        this.args = argsString;
    }

    public String getArgs() {
        return this.args;
    }

    public boolean getIsStdOut() {
        return this.isStdOut;
    }

    public void setOutputFile(String fileName) throws IOException {
        if (!this.isStdOut && this.outFile != null) {
            this.outFile.close();
        }
        this.outFile = new PrintWriter(new FileOutputStream(new File(fileName)));
        this.outFileName = fileName;
        this.isStdOut = false;
    }

    public void setOutputFile(PrintWriter fp, String name, boolean stdOutFlag) {
        if (!this.isStdOut && this.outFile != null) {
            this.outFile.close();
        }
        this.outFile = fp;
        this.outFileName = name;
        this.isStdOut = stdOutFlag;
    }

    public void closeInputFiles() throws IOException {
        while (!this.inFile.empty()) {
            InputFile file = this.inFile.pop();
            file.close();
        }
    }

    public void closeOutputFile() {
        if (this.outFile != null && !this.isStdOut) {
            System.out.println("isStdout is :" + this.isStdOut);
            System.out.println("Closing the output file");
            this.outFile.flush();
            this.outFile.close();
        }
        this.outFile = null;
        this.outFileName = null;
        this.isStdOut = false;
    }

    public void closeRecordFile() {
        if (this.recordFile != null) {
            this.recordFile.close();
        }
        this.recordFile = null;
    }

    public void setOutputFileName(String name) {
        this.outFileName = name;
    }

    public String getOutputFileName() {
        return this.outFileName;
    }

    public void setOutputToStdOut() {
        if (!this.isStdOut && this.outFile != null) {
            this.outFile.close();
            this.outFile = null;
        }
        this.outFileName = null;
        this.isStdOut = true;
        this.outFile = new PrintWriter(System.out);
    }

    public void setRecordFile(PrintWriter recFile) {
        if (this.recordFile != null) {
            this.recordFile.close();
            this.recordFile = null;
        }
        this.recordFile = recFile;
    }

    public PrintWriter getRecordFile() {
        return this.recordFile;
    }

    public BufferedReader getCurrentInputFile() {
        InputFile fp = this.inFile.peek();
        this.setCurrentInputFileName(fp.name);
        return fp.getFileReader();
    }

    public void setCurrentInputFile(InputFile ipFile) {
        this.setCurrentInputFileName(ipFile.getFileName());
        this.inFile.push(ipFile);
    }

    public void setCurrentInputFile(String name) throws FileNotFoundException {
        this.setCurrentInputFileName(name);
        this.inFile.push(new InputFile(name));
    }

    public void setCurrentInputToStdIn() {
        this.setCurrentInputFileName(null);
        this.inFile.push(new InputFile(System.in, true));
    }

    public void closeCurrentInputFile() throws IOException {
        InputFile temp = this.inFile.pop();
        temp.close();
        temp = null;
    }

    public boolean getPrimaryThread() {
        return this.primaryThread;
    }

    public void setPrimaryThread(boolean primary) {
        this.primaryThread = primary;
    }

    public PrintWriter getOutFile() {
        return this.outFile;
    }

    public String getCurrentInputFileName() {
        return this.currentInputFileName;
    }

    public void setCurrentInputFileName(String inFileName) {
        this.currentInputFileName = inFileName;
    }

    public boolean processCommentLine(String commentLine) throws IOException {
        if (commentLine.startsWith("## transaction")) {
            this.logTransaction(commentLine);
            return false;
        }
        return true;
    }

    protected void threadSleep(long sleepTimeInMilliSeconds) {
        if (sleepTimeInMilliSeconds > 0L) {
            try {
                Thread.sleep(sleepTimeInMilliSeconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected boolean isResultFileOpened() {
        return true;
    }

    protected void writeInResultFile(String content) {
    }

    protected void logTransaction(String commentLine) throws IOException {
    }
}

